/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

public enum SizeUnit {
    BYTES{

        @Override
        public long toBytes(long s) {
            return s;
        }

        @Override
        public long toKilobytes(long s) {
            return s / 1024L;
        }

        @Override
        public long toMegabytes(long s) {
            return s / 0x100000L;
        }

        @Override
        public long toGigabytes(long s) {
            return s / 0x40000000L;
        }

        @Override
        public long toTerabytes(long s) {
            return s / 0x10000000000L;
        }

        @Override
        public long convert(long s, SizeUnit u) {
            return u.toBytes(s);
        }
    }
    ,
    KILOBYTES{

        @Override
        public long toBytes(long s) {
            return 2.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long s) {
            return s;
        }

        @Override
        public long toMegabytes(long s) {
            return s / 1024L;
        }

        @Override
        public long toGigabytes(long s) {
            return s / 0x100000L;
        }

        @Override
        public long toTerabytes(long s) {
            return s / 0x40000000L;
        }

        @Override
        public long convert(long s, SizeUnit u) {
            return u.toKilobytes(s);
        }
    }
    ,
    MEGABYTES{

        @Override
        public long toBytes(long s) {
            return 3.x(s, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKilobytes(long s) {
            return 3.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long s) {
            return s;
        }

        @Override
        public long toGigabytes(long s) {
            return s / 1024L;
        }

        @Override
        public long toTerabytes(long s) {
            return s / 0x100000L;
        }

        @Override
        public long convert(long s, SizeUnit u) {
            return u.toMegabytes(s);
        }
    }
    ,
    GIGABYTES{

        @Override
        public long toBytes(long s) {
            return 4.x(s, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKilobytes(long s) {
            return 4.x(s, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMegabytes(long s) {
            return 4.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long s) {
            return s;
        }

        @Override
        public long toTerabytes(long s) {
            return s / 1024L;
        }

        @Override
        public long convert(long s, SizeUnit u) {
            return u.toGigabytes(s);
        }
    }
    ,
    TERABYTES{

        @Override
        public long toBytes(long s) {
            return 5.x(s, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toKilobytes(long s) {
            return 5.x(s, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMegabytes(long s) {
            return 5.x(s, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGigabytes(long s) {
            return 5.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTerabytes(long s) {
            return s;
        }

        @Override
        public long convert(long s, SizeUnit u) {
            return u.toTerabytes(s);
        }
    };

    static final long B0 = 1L;
    static final long B1 = 1024L;
    static final long B2 = 0x100000L;
    static final long B3 = 0x40000000L;
    static final long B4 = 0x10000000000L;

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public long toBytes(long size) {
        throw new AbstractMethodError();
    }

    public long toKilobytes(long size) {
        throw new AbstractMethodError();
    }

    public long toMegabytes(long size) {
        throw new AbstractMethodError();
    }

    public long toGigabytes(long size) {
        throw new AbstractMethodError();
    }

    public long toTerabytes(long size) {
        throw new AbstractMethodError();
    }

    public long convert(long sourceSize, SizeUnit sourceUnit) {
        throw new AbstractMethodError();
    }
}

