/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

import java.security.SecureRandom;
import org.torquebox.mojo.rubygems.ApiV1File;
import org.torquebox.mojo.rubygems.BaseGemFile;
import org.torquebox.mojo.rubygems.BundlerApiFile;
import org.torquebox.mojo.rubygems.DependencyFile;
import org.torquebox.mojo.rubygems.Directory;
import org.torquebox.mojo.rubygems.GemArtifactFile;
import org.torquebox.mojo.rubygems.GemArtifactIdDirectory;
import org.torquebox.mojo.rubygems.GemArtifactIdVersionDirectory;
import org.torquebox.mojo.rubygems.GemFile;
import org.torquebox.mojo.rubygems.GemspecFile;
import org.torquebox.mojo.rubygems.MavenMetadataFile;
import org.torquebox.mojo.rubygems.MavenMetadataSnapshotFile;
import org.torquebox.mojo.rubygems.NoContentFile;
import org.torquebox.mojo.rubygems.NotFoundFile;
import org.torquebox.mojo.rubygems.PomFile;
import org.torquebox.mojo.rubygems.RubygemsDirectory;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.RubygemsFileFactory;
import org.torquebox.mojo.rubygems.Sha1File;
import org.torquebox.mojo.rubygems.SpecsIndexFile;
import org.torquebox.mojo.rubygems.SpecsIndexType;
import org.torquebox.mojo.rubygems.SpecsIndexZippedFile;

public class DefaultRubygemsFileFactory
implements RubygemsFileFactory {
    public static final String ID = "DefaultRubygemsFileFactory";
    private static final String SEPARATOR = "/";
    private static final String GEMS = "/gems";
    private static final String QUICK_MARSHAL = "/quick/Marshal.4.8";
    private static final String API_V1 = "/api/v1";
    private static final String API_V1_DEPS = "/api/v1/dependencies";
    private static final String MAVEN_PRERELEASED_RUBYGEMS = "/maven/prereleases/rubygems";
    private static final String MAVEN_RELEASED_RUBYGEMS = "/maven/releases/rubygems";
    private static final SecureRandom random = new SecureRandom();

    private String join(String ... parts) {
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(part);
        }
        return builder.toString();
    }

    private String toPath(String name, String version, String timestamp, boolean snapshot) {
        String v1 = snapshot ? version + "-" + timestamp : version;
        String v2 = snapshot ? version + "-SNAPSHOT" : version;
        return this.join(snapshot ? MAVEN_PRERELEASED_RUBYGEMS : MAVEN_RELEASED_RUBYGEMS, SEPARATOR, name, SEPARATOR, v2, SEPARATOR, name + '-' + v1);
    }

    @Override
    public Sha1File sha1(RubygemsFile file) {
        return new Sha1File(this, file.storagePath() + ".sha1", file.remotePath() + ".sha1", file);
    }

    @Override
    public NoContentFile noContent(String path) {
        return new NoContentFile(this, path);
    }

    @Override
    public NotFoundFile notFound(String path) {
        return new NotFoundFile(this, path);
    }

    @Override
    public PomFile pomSnapshot(String name, String version, String timestamp) {
        return new PomFile((RubygemsFileFactory)this, this.toPath(name, version, timestamp, true) + ".pom", name, version, true);
    }

    @Override
    public GemArtifactFile gemArtifactSnapshot(String name, String version, String timestamp) {
        return new GemArtifactFile((RubygemsFileFactory)this, this.toPath(name, version, timestamp, true) + ".gem", name, version, true);
    }

    @Override
    public PomFile pom(String name, String version) {
        return new PomFile((RubygemsFileFactory)this, this.toPath(name, version, null, false) + ".pom", name, version, false);
    }

    @Override
    public GemArtifactFile gemArtifact(String name, String version) {
        return new GemArtifactFile((RubygemsFileFactory)this, this.toPath(name, version, null, false) + ".gem", name, version, false);
    }

    @Override
    public MavenMetadataSnapshotFile mavenMetadataSnapshot(String name, String version) {
        String path = this.join(MAVEN_PRERELEASED_RUBYGEMS, SEPARATOR, name, SEPARATOR, version + "-SNAPSHOT", SEPARATOR, "maven-metadata.xml");
        return new MavenMetadataSnapshotFile(this, path, name, version);
    }

    @Override
    public MavenMetadataFile mavenMetadata(String name, boolean prereleased) {
        String path = this.join(prereleased ? MAVEN_PRERELEASED_RUBYGEMS : MAVEN_RELEASED_RUBYGEMS, SEPARATOR, name, SEPARATOR, "maven-metadata.xml");
        return new MavenMetadataFile(this, path, name, prereleased);
    }

    @Override
    public Directory directory(String path, String ... items) {
        if (!path.endsWith(SEPARATOR)) {
            path = path + SEPARATOR;
        }
        return new Directory((RubygemsFileFactory)this, path, path.substring(0, path.length() - 1).replaceFirst(".*\\/", ""), items);
    }

    @Override
    public RubygemsDirectory rubygemsDirectory(String path) {
        if (!path.endsWith(SEPARATOR)) {
            path = path + SEPARATOR;
        }
        return new RubygemsDirectory(this, path);
    }

    @Override
    public GemArtifactIdDirectory gemArtifactIdDirectory(String path, String name, boolean prereleases) {
        if (!path.endsWith(SEPARATOR)) {
            path = path + SEPARATOR;
        }
        return new GemArtifactIdDirectory((RubygemsFileFactory)this, path, name, prereleases);
    }

    @Override
    public Directory gemArtifactIdVersionDirectory(String path, String name, String version, boolean prerelease) {
        if (!path.endsWith(SEPARATOR)) {
            path = path + SEPARATOR;
        }
        return new GemArtifactIdVersionDirectory((RubygemsFileFactory)this, path, name, version, prerelease);
    }

    @Override
    public GemFile gemFile(String name, String version, String platform) {
        String filename = BaseGemFile.toFilename(name, version, platform);
        return new GemFile(this, this.join(GEMS, SEPARATOR, name.substring(0, 1), SEPARATOR, filename, ".gem"), this.join(GEMS, SEPARATOR, filename, ".gem"), name, version, platform);
    }

    @Override
    public GemFile gemFile(String name) {
        return new GemFile(this, this.join(GEMS, SEPARATOR, name.substring(0, 1), SEPARATOR, name, ".gem"), this.join(GEMS, SEPARATOR, name, ".gem"), name);
    }

    @Override
    public GemspecFile gemspecFile(String name, String version, String platform) {
        String filename = BaseGemFile.toFilename(name, version, platform);
        return new GemspecFile(this, this.join(QUICK_MARSHAL, SEPARATOR, name.substring(0, 1), SEPARATOR, filename, ".gemspec.rz"), this.join(QUICK_MARSHAL, SEPARATOR, filename, ".gemspec.rz"), name, version, platform);
    }

    @Override
    public GemspecFile gemspecFile(String name) {
        return new GemspecFile(this, this.join(QUICK_MARSHAL, SEPARATOR, name.substring(0, 1), SEPARATOR, name, ".gemspec.rz"), this.join(QUICK_MARSHAL, SEPARATOR, name, ".gemspec.rz"), name);
    }

    @Override
    public DependencyFile dependencyFile(String name) {
        return new DependencyFile(this, this.join(API_V1_DEPS, SEPARATOR, name, ".ruby"), this.join(API_V1_DEPS, "?gems=" + name), name);
    }

    @Override
    public BundlerApiFile bundlerApiFile(String names) {
        names = names.replaceAll("%2C", ",").replaceAll(",,", ",").replaceAll("\\s+", "").replaceAll(",\\s*$", "");
        return new BundlerApiFile((RubygemsFileFactory)this, this.join(API_V1_DEPS, "?gems=" + names), names.split(","));
    }

    @Override
    public BundlerApiFile bundlerApiFile(String ... names) {
        StringBuilder gems = new StringBuilder("?gems=");
        boolean first = true;
        for (String name : names) {
            if (first) {
                first = false;
            } else {
                gems.append(",");
            }
            gems.append(name);
        }
        return new BundlerApiFile((RubygemsFileFactory)this, this.join(API_V1_DEPS, gems.toString()), names);
    }

    @Override
    public ApiV1File apiV1File(String name) {
        return new ApiV1File(this, this.join(API_V1, SEPARATOR, Long.toString(Math.abs(random.nextLong())), ".", name), this.join(API_V1, SEPARATOR, name), name);
    }

    @Override
    public SpecsIndexFile specsIndexFile(SpecsIndexType type) {
        return this.specsIndexFile(type.filename().replace(".4.8", ""));
    }

    @Override
    public SpecsIndexFile specsIndexFile(String name) {
        return new SpecsIndexFile(this, this.join(SEPARATOR, name, ".4.8"), name);
    }

    @Override
    public SpecsIndexZippedFile specsIndexZippedFile(String name) {
        return new SpecsIndexZippedFile(this, this.join(SEPARATOR, name, ".4.8", ".gz"), name);
    }

    @Override
    public SpecsIndexZippedFile specsIndexZippedFile(SpecsIndexType type) {
        return this.specsIndexZippedFile(type.filename().replace(".4.8", ""));
    }

    static {
        random.setSeed(System.currentTimeMillis());
    }
}

