/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

public enum SpecsIndexType {
    RELEASE,
    PRERELEASE,
    LATEST;


    public String filename() {
        StringBuilder name = new StringBuilder();
        if (this != RELEASE) {
            name.append(this.name().toLowerCase().replaceFirst("^release", "")).append("_");
        }
        return name.append("specs.4.8").toString();
    }

    public String filepath() {
        return "/" + this.filename();
    }

    public String filepathGzipped() {
        return this.filepath() + ".gz";
    }

    public static SpecsIndexType fromFilename(String name) {
        try {
            name = name.replace(".gz", "").replace("/", "").toUpperCase();
            if ("SPECS.4.8".equals(name)) {
                return RELEASE;
            }
            name = name.replace("SPECS.4.8", "").replace("_", "");
            return SpecsIndexType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

