/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.cuba.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.cuba.Cuba;
import org.torquebox.mojo.rubygems.cuba.State;

public class ApiV1DependenciesCuba
implements Cuba {
    public static final String RUBY = ".ruby";
    private static final Pattern FILE = Pattern.compile("^([^/]+)[.]" + ".ruby".substring(1) + "$");

    @Override
    public RubygemsFile on(State state) {
        Matcher m;
        if (state.name.isEmpty()) {
            if (state.context.query.startsWith("gems=")) {
                if (state.context.query.contains(",") || state.context.query.contains("%2C")) {
                    return state.context.factory.bundlerApiFile(state.context.query.substring(5));
                }
                if (state.context.query.length() > 5) {
                    return state.context.factory.dependencyFile(state.context.query.substring(5));
                }
            }
            if (state.context.original.endsWith("/")) {
                return state.context.factory.directory(state.context.original, new String[0]);
            }
            return state.context.factory.noContent(state.context.original);
        }
        if (state.name.length() == 1) {
            if (state.path.length() < 2) {
                return state.context.factory.directory(state.context.original, new String[0]);
            }
            m = FILE.matcher(state.path.substring(1));
        } else {
            m = FILE.matcher(state.name);
        }
        if (m.matches()) {
            return state.context.factory.dependencyFile(m.group(1));
        }
        return state.context.factory.notFound(state.context.original);
    }
}

