/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.cuba.maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.torquebox.mojo.rubygems.GemArtifactFile;
import org.torquebox.mojo.rubygems.PomFile;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.cuba.Cuba;
import org.torquebox.mojo.rubygems.cuba.State;

public class MavenReleasesRubygemsArtifactIdVersionCuba
implements Cuba {
    private static final Pattern FILE = Pattern.compile("^.*\\.(gem|pom|gem.sha1|pom.sha1)$");
    private final String artifactId;
    private final String version;

    public MavenReleasesRubygemsArtifactIdVersionCuba(String artifactId, String version) {
        this.artifactId = artifactId;
        this.version = version;
    }

    @Override
    public RubygemsFile on(State state) {
        Matcher m = FILE.matcher(state.name);
        if (m.matches()) {
            switch (m.group(1)) {
                case "gem": {
                    return state.context.factory.gemArtifact(this.artifactId, this.version);
                }
                case "pom": {
                    return state.context.factory.pom(this.artifactId, this.version);
                }
                case "gem.sha1": {
                    GemArtifactFile file = state.context.factory.gemArtifact(this.artifactId, this.version);
                    return state.context.factory.sha1(file);
                }
                case "pom.sha1": {
                    PomFile file = state.context.factory.pom(this.artifactId, this.version);
                    return state.context.factory.sha1(file);
                }
            }
        }
        switch (state.name) {
            case "": {
                return state.context.factory.gemArtifactIdVersionDirectory(state.context.original, this.artifactId, this.version, false);
            }
        }
        return state.context.factory.notFound(state.context.original);
    }
}

