/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.layout;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.torquebox.mojo.rubygems.DependencyFile;
import org.torquebox.mojo.rubygems.Directory;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.SpecsIndexFile;
import org.torquebox.mojo.rubygems.SpecsIndexZippedFile;
import org.torquebox.mojo.rubygems.layout.Storage;

public class SimpleStorage
implements Storage {
    private final SecureRandom random = new SecureRandom();
    private final File basedir;

    public SimpleStorage(File basedir) {
        this.basedir = basedir;
        this.random.setSeed(System.currentTimeMillis());
    }

    @Override
    public InputStream getInputStream(RubygemsFile file) throws IOException {
        if (file.hasException()) {
            throw new IOException(file.getException());
        }
        InputStream is = file.get() == null ? Files.newInputStream(this.toPath(file), new OpenOption[0]) : ((StreamLocation)file.get()).openStream();
        file.resetState();
        return is;
    }

    protected Path toPath(RubygemsFile file) {
        return new File(this.basedir, file.storagePath()).toPath();
    }

    @Override
    public long getModified(RubygemsFile file) {
        return this.toPath(file).toFile().lastModified();
    }

    @Override
    public void retrieve(RubygemsFile file) {
        file.resetState();
        Path path = this.toPath(file);
        if (Files.notExists(path, new LinkOption[0])) {
            file.markAsNotExists();
        } else {
            try {
                this.set(file, path);
            }
            catch (IOException e) {
                file.setException(e);
            }
        }
    }

    @Override
    public void retrieve(DependencyFile file) {
        this.retrieve((RubygemsFile)file);
    }

    @Override
    public void retrieve(SpecsIndexZippedFile file) {
        this.retrieve((RubygemsFile)file);
    }

    @Override
    public void retrieve(SpecsIndexFile file) {
        SpecsIndexZippedFile zipped = file.zippedSpecsIndexFile();
        this.retrieve(zipped);
        if (zipped.notExists()) {
            file.markAsNotExists();
        }
        if (zipped.hasException()) {
            file.setException(zipped.getException());
        } else {
            file.set(new URLGzipStreamLocation((StreamLocation)zipped.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(InputStream is, RubygemsFile file) {
        Path target = this.toPath(file);
        Path mutex = target.resolveSibling(target.getFileName() + ".lock");
        Path source = target.resolveSibling("tmp." + Math.abs(this.random.nextLong()));
        try {
            this.createDirectory(source.getParent());
            Files.createFile(mutex, new FileAttribute[0]);
            Files.copy(is, source, new CopyOption[0]);
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
            this.set(file, target);
        }
        catch (FileAlreadyExistsException e) {
            mutex = null;
            file.markAsTempUnavailable();
        }
        catch (IOException e) {
            file.setException(e);
        }
        finally {
            if (mutex != null) {
                mutex.toFile().delete();
            }
            source.toFile().delete();
        }
    }

    private void set(RubygemsFile file, Path path) throws MalformedURLException {
        file.set(new URLStreamLocation(path.toUri().toURL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(InputStream is, RubygemsFile file) {
        Path target = this.toPath(file);
        Path source = target.resolveSibling("tmp." + Math.abs(this.random.nextLong()));
        try {
            this.createDirectory(source.getParent());
            Files.copy(is, source, new CopyOption[0]);
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE);
            this.set(file, target);
        }
        catch (IOException e) {
            file.setException(e);
        }
        finally {
            source.toFile().delete();
        }
    }

    protected void createDirectory(Path parent) throws IOException {
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    @Override
    public void delete(RubygemsFile file) {
        try {
            Files.deleteIfExists(this.toPath(file));
        }
        catch (IOException e) {
            file.setException(e);
        }
    }

    @Override
    public void memory(ByteArrayInputStream data, RubygemsFile file) {
        file.set(new BytesStreamLocation(data));
    }

    @Override
    public void memory(String data, RubygemsFile file) {
        this.memory(new ByteArrayInputStream(data.getBytes()), file);
    }

    @Override
    public String[] listDirectory(Directory dir) {
        String[] list = this.toPath(dir).toFile().list();
        if (list == null) {
            list = new String[]{};
        }
        return list;
    }

    static class URLGzipStreamLocation
    implements StreamLocation {
        private StreamLocation stream;

        URLGzipStreamLocation(StreamLocation stream) {
            this.stream = stream;
        }

        @Override
        public InputStream openStream() throws IOException {
            return new GZIPInputStream(this.stream.openStream());
        }
    }

    static class BytesStreamLocation
    implements StreamLocation {
        private ByteArrayInputStream stream;

        BytesStreamLocation(ByteArrayInputStream stream) {
            this.stream = stream;
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.stream;
        }
    }

    static class URLStreamLocation
    implements StreamLocation {
        private URL url;
        private Base64 base64 = new Base64();

        URLStreamLocation(URL url) {
            this.url = url;
        }

        public URLConnection openConnection() throws IOException {
            URLConnection con = this.url.openConnection();
            String userinfo = this.url.getUserInfo();
            if (userinfo != null) {
                String basicAuth = "Basic " + Base64.encodeBase64String((byte[])URLDecoder.decode(userinfo, "UTF-8").getBytes(StandardCharsets.UTF_8));
                con.setRequestProperty("Authorization", basicAuth);
            }
            return con;
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.openConnection().getInputStream();
        }
    }

    static interface StreamLocation {
        public InputStream openStream() throws IOException;
    }
}

