/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.generic.deployer.DeployerFactory;
import org.codehaus.cargo.maven2.AbstractCargoMojo;

public abstract class AbstractDeployerMojo
extends AbstractCargoMojo {
    private DeployerFactory deployerFactory = new DefaultDeployerFactory();

    public void doExecute() throws MojoExecutionException {
        Container container = this.createContainer();
        Deployer deployer = this.createDeployer(container);
        this.performDeployerActionOnAllDeployables(container, deployer);
    }

    public void setDeployerFactory(DeployerFactory factory) {
        this.deployerFactory = factory;
    }

    public DeployerFactory getDeployerFactory() {
        return this.deployerFactory;
    }

    protected Deployer createDeployer(Container container) throws MojoExecutionException {
        Deployer deployer = this.getDeployerElement() == null ? this.getDeployerFactory().createDeployer(container) : this.getDeployerElement().createDeployer(container);
        return deployer;
    }

    private void performDeployerActionOnAllDeployables(Container container, Deployer deployer) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Performing deployment action into [" + container.getName() + "]..."));
        if (this.getDeployerElement() != null) {
            for (int i = 0; i < this.getDeployerElement().getDeployables().length; ++i) {
                Deployable deployable = this.getDeployerElement().getDeployables()[i].createDeployable(container.getId(), this.getCargoProject());
                URL pingURL = this.getDeployerElement().getDeployables()[i].getPingURL();
                Long pingTimeout = this.getDeployerElement().getDeployables()[i].getPingTimeout();
                this.performDeployerActionOnSingleDeployable(deployer, deployable, pingURL, pingTimeout);
            }
        }
        if (this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() && (this.getDeployerElement() == null || this.getDeployerElement().getDeployables() == null || !this.containsAutoDeployable(this.getDeployerElement().getDeployables()))) {
            this.performDeployerActionOnSingleDeployable(deployer, this.createAutoDeployDeployable(container), null, null);
        }
    }

    protected abstract void performDeployerActionOnSingleDeployable(Deployer var1, Deployable var2, URL var3, Long var4);
}

