/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.cargo.maven2.AbstractUberWarMojo;
import org.codehaus.cargo.maven2.DependencyCalculator;
import org.codehaus.cargo.maven2.Merge;
import org.codehaus.cargo.maven2.MergeRoot;
import org.codehaus.cargo.maven2.io.xpp3.UberWarXpp3Reader;
import org.codehaus.cargo.maven2.merge.MergeWebXml;
import org.codehaus.cargo.maven2.merge.MergeXslt;
import org.codehaus.cargo.module.merge.DocumentStreamAdapter;
import org.codehaus.cargo.module.merge.MergeException;
import org.codehaus.cargo.module.merge.MergeProcessor;
import org.codehaus.cargo.module.webapp.DefaultWarArchive;
import org.codehaus.cargo.module.webapp.WarArchive;
import org.codehaus.cargo.module.webapp.merge.WarArchiveMerger;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom.JDOMException;

public class UberWarMojo
extends AbstractUberWarMojo
implements Contextualizable {
    private String outputDirectory;
    private String warName;
    private File descriptor;
    private boolean resolveDependencies = false;
    private String descriptorId;
    private List wars;
    private PlexusConfiguration settings;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private MavenProject mavenProject;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactInstaller installer;
    private PlexusContainer container;

    protected File getConfigDirectory() {
        return this.descriptor.getParentFile();
    }

    public void execute() throws MojoExecutionException {
        InputStreamReader r = null;
        if (this.descriptor != null) {
            try {
                r = new FileReader(this.descriptor);
            }
            catch (FileNotFoundException ex) {
                throw new MojoExecutionException("Could not find specified descriptor");
            }
        } else if (this.descriptorId != null) {
            InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/uberwar/" + this.descriptorId + ".xml");
            if (resourceAsStream == null) {
                throw new MojoExecutionException("Descriptor with ID '" + this.descriptorId + "' not found");
            }
            r = new InputStreamReader(resourceAsStream);
        } else {
            throw new MojoExecutionException("You must specify descriptor or descriptorId");
        }
        try {
            Iterator i;
            UberWarXpp3Reader reader = new UberWarXpp3Reader();
            MergeRoot root = reader.read(r);
            WarArchiveMerger wam = new WarArchiveMerger();
            List wars = root.getWars();
            if (wars.size() == 0) {
                this.addAllWars(wam);
            } else {
                i = wars.iterator();
                while (i.hasNext()) {
                    String id = (String)i.next();
                    this.addWar(wam, id);
                }
            }
            if (this.resolveDependencies) {
                wam.setMergeJarFiles(false);
                this.addAllTransitiveJars(wam);
            } else {
                this.addAllDependentJars(wam);
            }
            i = root.getMerges().iterator();
            while (i.hasNext()) {
                Merge merge = (Merge)i.next();
                this.doMerge(wam, merge);
            }
            File warFile = new File(this.outputDirectory, this.warName + ".war");
            WarArchive output = (WarArchive)wam.performMerge();
            output.store(warFile);
            this.getProject().getArtifact().setFile(warFile);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Invalid XML descriptor", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException creating UBERWAR", (Exception)e);
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Xml format exception creating UBERWAR", (Exception)((Object)e));
        }
        catch (MergeException e) {
            throw new MojoExecutionException("Merging exception creating UBERWAR", (Exception)((Object)e));
        }
    }

    private void doMerge(WarArchiveMerger wam, Merge merge) throws MojoExecutionException {
        try {
            String type = merge.getType();
            String file = merge.getFile();
            String document = merge.getDocument();
            String clazz = merge.getClassname();
            MergeProcessor merger = null;
            if (type != null) {
                if (type.equalsIgnoreCase("web.xml")) {
                    merger = new MergeWebXml(this.getConfigDirectory()).create(wam, merge);
                } else if (type.equalsIgnoreCase("xslt")) {
                    merger = new MergeXslt(this.descriptor.getParentFile()).create(wam, merge);
                }
            } else {
                merger = (MergeProcessor)Class.forName(clazz).newInstance();
            }
            if (merger != null) {
                if (document != null) {
                    merger = new DocumentStreamAdapter(merger);
                    wam.addMergeProcessor(document, merger);
                } else if (file != null) {
                    wam.addMergeProcessor(file, merger);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Problem in file merge", e);
        }
    }

    protected void addAllTransitiveJars(WarArchiveMerger wam) throws MojoExecutionException {
        DependencyCalculator dc = new DependencyCalculator(this.artifactFactory, this.resolver, this.localRepository, this.remoteRepositories, this.mavenProject, this.mavenProjectBuilder, this.installer, this.container);
        try {
            Iterator i = dc.execute().iterator();
            while (i.hasNext()) {
                wam.addMergeItem(i.next());
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Problem merging dependent JAR files", ex);
        }
    }

    protected void addAllDependentJars(WarArchiveMerger wam) throws MojoExecutionException {
        Iterator iter = this.getProject().getArtifacts().iterator();
        while (iter.hasNext()) {
            String type;
            Artifact artifact = (Artifact)iter.next();
            System.out.println("See " + artifact);
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"jar".equals(type = artifact.getType())) continue;
            System.out.println("use " + artifact);
            try {
                wam.addMergeItem((Object)artifact.getFile());
            }
            catch (MergeException e) {
                throw new MojoExecutionException("Problem merging WAR", (Exception)((Object)e));
            }
        }
    }

    protected void addWar(WarArchiveMerger wam, String artifactIdent) throws MojoExecutionException, IOException {
        Iterator iter = this.getProject().getArtifacts().iterator();
        while (iter.hasNext()) {
            String name;
            String type;
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"war".equals(type = artifact.getType()) || !(name = artifact.getGroupId() + ":" + artifact.getArtifactId()).equals(artifactIdent)) continue;
            try {
                wam.addMergeItem((Object)new DefaultWarArchive(artifact.getFile().getPath()));
            }
            catch (MergeException e) {
                throw new MojoExecutionException("Problem merging WAR", (Exception)((Object)e));
            }
            return;
        }
        throw new MojoExecutionException("Could not find a dependent WAR file matching " + artifactIdent);
    }

    protected void addAllWars(WarArchiveMerger wam) throws MojoExecutionException, IOException {
        Iterator iter = this.getProject().getArtifacts().iterator();
        while (iter.hasNext()) {
            String type;
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"war".equals(type = artifact.getType())) continue;
            try {
                wam.addMergeItem((Object)new DefaultWarArchive(artifact.getFile().getPath()));
            }
            catch (MergeException e) {
                throw new MojoExecutionException("Problem merging WAR", (Exception)((Object)e));
            }
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

