/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractDependency {
    private String groupId;
    private String artifactId;
    private String type;
    private String location;
    private String classifier;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getClassifier() {
        return this.classifier;
    }

    protected String findArtifactLocation(Set artifacts, Log log) throws MojoExecutionException {
        Artifact resolvedArtifact = null;
        log.debug((CharSequence)("Searching for an artifact that matches [" + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + ":" + this.getClassifier() + "]..."));
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            log.debug((CharSequence)("Checking artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + "]..."));
            if (!artifact.getGroupId().equals(this.getGroupId()) || !artifact.getArtifactId().equals(this.getArtifactId()) || artifact.getClassifier() != this.getClassifier() && (artifact.getClassifier() == null || !artifact.getClassifier().equals(this.getClassifier()))) continue;
            resolvedArtifact = artifact;
            break;
        }
        if (resolvedArtifact == null) {
            throw new MojoExecutionException("Artifact [" + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + "] is not a dependency of the project.");
        }
        return resolvedArtifact.getFile().getPath();
    }
}

