/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import java.util.Iterator;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configfile;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.maven2.configuration.Deployable;
import org.codehaus.cargo.maven2.configuration.Resource;
import org.codehaus.cargo.maven2.util.CargoProject;

public class Configuration {
    private String type = ConfigurationType.STANDALONE.getType();
    private String implementation;
    private String home;
    private Map properties;
    private Deployable[] deployables;
    private Configfile[] configfiles;
    private Resource[] resources;

    public ConfigurationType getType() {
        return ConfigurationType.toType((String)this.type);
    }

    public void setType(ConfigurationType type) {
        this.type = type.getType();
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Deployable[] getDeployables() {
        return this.deployables;
    }

    public void setDeployables(Deployable[] deployables) {
        this.deployables = deployables;
    }

    public Configfile[] getConfigfiles() {
        return this.configfiles;
    }

    public void setConfigfiles(Configfile[] configfiles) {
        this.configfiles = configfiles;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] rlist) {
        this.resources = rlist;
    }

    public org.codehaus.cargo.container.configuration.Configuration createConfiguration(String containerId, ContainerType containerType, CargoProject project) throws MojoExecutionException {
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getImplementation() != null) {
            try {
                Class<?> configurationClass = Class.forName(this.getImplementation(), true, this.getClass().getClassLoader());
                factory.registerConfiguration(containerId, containerType, this.getType(), configurationClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MojoExecutionException("Custom configuration implementation [" + this.getImplementation() + "] cannot be loaded", (Exception)cnfe);
            }
        }
        org.codehaus.cargo.container.configuration.Configuration configuration = this.getHome() == null ? factory.createConfiguration(containerId, containerType, this.getType()) : factory.createConfiguration(containerId, containerType, this.getType(), this.getHome());
        if (this.getProperties() != null) {
            Iterator itProperties = this.getProperties().keySet().iterator();
            while (itProperties.hasNext()) {
                String propertyName = (String)itProperties.next();
                String propertyValue = (String)this.getProperties().get(propertyName);
                if (propertyValue == null) {
                    propertyValue = "";
                }
                configuration.setProperty(propertyName, propertyValue);
            }
        }
        if (configuration instanceof LocalConfiguration) {
            if (this.getDeployables() != null) {
                this.addStaticDeployables(containerId, (LocalConfiguration)configuration, project);
            }
            if (this.getResources() != null) {
                this.addResources(containerId, (LocalConfiguration)configuration, project);
            }
        }
        if (configuration instanceof StandaloneLocalConfiguration && this.getConfigfiles() != null) {
            for (int i = 0; i < this.getConfigfiles().length; ++i) {
                ((StandaloneLocalConfiguration)configuration).setFileProperty(this.getConfigfiles()[i].getFile(), this.getConfigfiles()[i].getToFile(), this.getConfigfiles()[i].getToDir());
            }
        }
        return configuration;
    }

    private void addResources(String containerId, LocalConfiguration configuration, CargoProject project) throws MojoExecutionException {
        for (int i = 0; i < this.getResources().length; ++i) {
            configuration.addResource(this.getResources()[i].createResource(containerId, project));
        }
    }

    private void addStaticDeployables(String containerId, LocalConfiguration configuration, CargoProject project) throws MojoExecutionException {
        for (int i = 0; i < this.getDeployables().length; ++i) {
            project.getLog().debug((CharSequence)("Scheduling deployable for deployment: [groupId [" + this.getDeployables()[i].getGroupId() + "], artifactId [" + this.getDeployables()[i].getArtifactId() + "], type [" + this.getDeployables()[i].getType() + "], location [" + this.getDeployables()[i].getLocation() + "], pingURL [" + this.getDeployables()[i].getPingURL() + "]]"));
            configuration.addDeployable(this.getDeployables()[i].createDeployable(containerId, project));
        }
    }
}

