/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.shaded.mojoexecutor.MojoExecutor;
import org.twdata.maven.cli.CommandTokenCollector;
import org.twdata.maven.cli.MojoCall;
import org.twdata.maven.cli.commands.Command;
import org.twdata.maven.cli.commands.CommandDescription;
import org.twdata.maven.cli.console.CliConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteGoalCommand
implements Command {
    private final Map<String, String> defaultGoals = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("compile", "org.apache.maven.plugins:maven-compiler-plugin:compile");
            this.put("testCompile", "org.apache.maven.plugins:maven-compiler-plugin:testCompile");
            this.put("jar", "org.apache.maven.plugins:maven-jar-plugin:jar");
            this.put("war", "org.apache.maven.plugins:maven-war-plugin:war");
            this.put("resources", "org.apache.maven.plugins:maven-resources-plugin:resources");
            this.put("testResources", "org.apache.maven.plugins:maven-resources-plugin:testResources");
            this.put("install", "org.apache.maven.plugins:maven-install-plugin:install");
            this.put("deploy", "org.apache.maven.plugins:maven-deploy-plugin:deploy");
            this.put("test", "org.apache.maven.plugins:maven-surefire-plugin:test");
            this.put("clean", "org.apache.maven.plugins:maven-clean-plugin:clean");
            this.put("help-system", "org.apache.maven.plugins:maven-help-plugin:system");
            this.put("help-effectivesettings", "org.apache.maven.plugins:maven-help-plugin:effective-settings");
            this.put("help-allprofiles", "org.apache.maven.plugins:maven-help-plugin:all-profiles");
            this.put("dependency-tree", "org.apache.maven.plugins:maven-dependency-plugin:tree");
            this.put("dependency-resolve", "org.apache.maven.plugins:maven-dependency-plugin:resolve");
            this.put("dependency-resolve-plugins", "org.apache.maven.plugins:maven-dependency-plugin:resolve-plugins");
            this.put("dependency-purge", "org.apache.maven.plugins:maven-dependency-plugin:purge-local-repository");
            this.put("dependency-analyze", "org.apache.maven.plugins:maven-dependency-plugin:analyze");
        }
    });
    private final Map<String, String> userDefinedAliases;
    private final MavenProject project;
    private final MavenSession session;
    private final MojoExecutor.ExecutionEnvironment executionEnvironment;

    public ExecuteGoalCommand(MavenProject project, MavenSession session, MojoExecutor.ExecutionEnvironment executionEnvironment, Map<String, String> userDefinedAliases) {
        this.project = project;
        this.session = session;
        this.executionEnvironment = executionEnvironment;
        this.userDefinedAliases = userDefinedAliases;
    }

    @Override
    public void describe(CommandDescription description) {
        description.describeCommandName("Goal commands");
        for (String goal : this.defaultGoals.keySet()) {
            description.describeCommandToken(goal, this.defaultGoals.get(goal));
        }
        for (String alias : this.userDefinedAliases.keySet()) {
            description.describeCommandToken(alias, this.userDefinedAliases.get(alias));
        }
    }

    @Override
    public void collectCommandTokens(CommandTokenCollector collector) {
        collector.addCommandTokens(this.defaultGoals.keySet());
        collector.addCommandTokens(this.userDefinedAliases.keySet());
    }

    @Override
    public boolean matchesRequest(String request) {
        for (String token : request.split(" ")) {
            if (this.defaultGoals.containsKey(token) || this.userDefinedAliases.containsKey(token) || token.split(":").length >= 3) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean run(String request, CliConsole console) {
        for (String token : request.split(" ")) {
            try {
                if (this.defaultGoals.containsKey(token)) {
                    this.runMojo(this.defaultGoals.get(token), console);
                    continue;
                }
                if (this.userDefinedAliases.containsKey(token)) {
                    this.run(this.userDefinedAliases.get(token), console);
                    continue;
                }
                this.runMojo(token, console);
            }
            catch (MojoExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return true;
    }

    private void runMojo(String mojoString, CliConsole console) throws MojoExecutionException {
        String[] mojoInfo = mojoString.split(":");
        MojoCall call = new MojoCall(mojoInfo[0], mojoInfo[1], mojoInfo[2]);
        console.writeInfo("Executing: " + call);
        long start = System.currentTimeMillis();
        call.run(this.project, this.session, this.executionEnvironment);
        long now = System.currentTimeMillis();
        console.writeInfo("Current project: " + this.project.getArtifactId());
        console.writeInfo("Execution time: " + (now - start) + " ms");
    }
}

