/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.twdata.maven.cli.CommandTokenCollector;
import org.twdata.maven.cli.PhaseCall;
import org.twdata.maven.cli.PhaseCallRunner;
import org.twdata.maven.cli.commands.Command;
import org.twdata.maven.cli.commands.CommandDescription;
import org.twdata.maven.cli.commands.PhaseCallBuilder;
import org.twdata.maven.cli.console.CliConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutePhaseCommand
implements Command {
    private final Set<String> modules;
    private final PhaseCallBuilder phaseCallBuilder;
    private final PhaseCallRunner runner;
    private final SortedSet<String> phasesAndProperties = new TreeSet<String>();
    private final Set<String> userAliases;
    private final boolean ignoreFailures;

    public ExecutePhaseCommand(Set<String> userAliases, Set<String> modules, PhaseCallBuilder phaseCallBuilder, PhaseCallRunner runner, boolean ignoreFailures) {
        this.userAliases = userAliases;
        this.modules = modules;
        this.phaseCallBuilder = phaseCallBuilder;
        this.runner = runner;
        this.ignoreFailures = ignoreFailures;
        this.phasesAndProperties.add("clean");
        this.phasesAndProperties.add("compile");
        this.phasesAndProperties.add("validate");
        this.phasesAndProperties.add("generate-sources");
        this.phasesAndProperties.add("generate-resources");
        this.phasesAndProperties.add("test-compile");
        this.phasesAndProperties.add("test");
        this.phasesAndProperties.add("package");
        this.phasesAndProperties.add("integration-test");
        this.phasesAndProperties.add("install");
        this.phasesAndProperties.add("deploy");
        this.phasesAndProperties.add("site");
        this.phasesAndProperties.add("site-deploy");
        this.phasesAndProperties.add("-o");
        this.phasesAndProperties.add("-N");
        this.phasesAndProperties.add("-S");
    }

    @Override
    public void describe(CommandDescription description) {
        description.describeCommandName("Phase Commands");
        for (String phase : this.phasesAndProperties) {
            if (phase.startsWith("-")) continue;
            description.describeCommandToken(phase, null);
        }
        for (String userAlias : this.userAliases) {
            description.describeCommandToken(userAlias, null);
        }
    }

    @Override
    public void collectCommandTokens(CommandTokenCollector collector) {
        collector.addCommandTokens(this.phasesAndProperties);
        collector.addCommandTokens(this.modules);
        collector.addCommandTokens(this.userAliases);
    }

    @Override
    public boolean matchesRequest(String request) {
        for (String token : request.split(" ")) {
            if (this.phasesAndProperties.contains(token) || token.startsWith("-D") || token.startsWith("-P") || this.userAliases.contains(token) || this.matchesModules(token) || !this.isInvalidPluginGoalCommand(token)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesModules(String token) {
        String regex = token.replaceAll("\\*", ".*").replaceAll("\\?", "\\\\?");
        for (String module : this.modules) {
            if (!module.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private boolean isInvalidPluginGoalCommand(String token) {
        String[] goalConstruct = token.split(":");
        if (goalConstruct.length != 2 && goalConstruct.length != 3) {
            return true;
        }
        for (String construct : goalConstruct) {
            if (!"".equals(construct)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(String request, CliConsole console) {
        try {
            List<Object> calls = new ArrayList();
            calls = this.phaseCallBuilder.parseCommand(request);
            for (PhaseCall phaseCall : calls) {
                console.writeDebug("Executing: " + phaseCall);
                long start = System.currentTimeMillis();
                boolean success = phaseCall.run(this.runner, console);
                long now = System.currentTimeMillis();
                console.writeInfo("Execution time: " + (now - start) + " ms");
                if (this.ignoreFailures || success) continue;
            }
        }
        catch (IllegalArgumentException ex) {
            console.writeError("Invalid command: " + request);
        }
        finally {
            return true;
        }
    }
}

