/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.plugin.PluginProcessor;
import org.uberfire.workbench.events.PluginReloadedEvent;

@Dependent
public class PluginJarProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PluginJarProcessor.class);
    private Instance<PluginProcessor> pluginProcessors;
    private String pluginsDir;
    private String pluginsDeploymentUrlPath;
    private String pluginsDeploymentDir;
    private Event<PluginReloadedEvent> pluginsReloadedEvent;

    @Inject
    public PluginJarProcessor(@Any Instance<PluginProcessor> pluginProcessors, Event<PluginReloadedEvent> pluginsReloadedEvent) {
        this.pluginProcessors = pluginProcessors;
        this.pluginsReloadedEvent = pluginsReloadedEvent;
    }

    public void init(String pluginsDir, String pluginsDeploymentDir) throws IOException {
        this.pluginsDeploymentUrlPath = StringUtils.substringAfterLast((String)pluginsDeploymentDir, (String)File.separator);
        this.pluginsDeploymentDir = pluginsDeploymentDir;
        this.pluginsDir = pluginsDir;
        this.loadPlugins();
    }

    void loadPlugins() throws IOException {
        this.removeAllPlugins();
        File pluginsRoot = new File(this.pluginsDir);
        if (pluginsRoot.exists()) {
            Collection deployedPlugins = FileUtils.listFiles((File)pluginsRoot, (String[])new String[]{"jar"}, (boolean)false);
            deployedPlugins.forEach(p -> this.loadPlugins(Paths.get(p.getAbsolutePath(), new String[0]), false));
        }
    }

    void removeAllPlugins() {
        this.pluginProcessors.forEach(p -> p.removeAll());
    }

    public void reload() throws IOException {
        this.loadPlugins();
        this.pluginsReloadedEvent.fire((Object)new PluginReloadedEvent());
    }

    public void loadPlugins(Path path, boolean notifyClients) {
        List<String> pluginsFiles = this.extractFilesFromPluginsJar(this.pluginsDir + File.separator + path.toFile().getName());
        if (!pluginsFiles.isEmpty()) {
            for (String pluginName : pluginsFiles) {
                for (PluginProcessor pluginRegistry : this.pluginProcessors) {
                    if (!pluginRegistry.shouldProcess(pluginName)) continue;
                    pluginRegistry.process(pluginName, this.pluginsDeploymentDir, notifyClients);
                }
            }
        } else {
            LOG.warn("Deployed plugin " + path.toFile().getName() + " does not contain any plugins!");
        }
    }

    List<String> extractFilesFromPluginsJar(String jarFileName) {
        ArrayList<String> pluginsFiles = new ArrayList<String>();
        try (JarFile jar = new JarFile(jarFileName);){
            Enumeration<JarEntry> enumEntries = jar.entries();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                String fileName = StringUtils.substringAfterLast((String)file.getName(), (String)File.separator);
                if (!PluginProcessor.isAValidPluginFileExtension((String)fileName)) continue;
                File f = new File(this.pluginsDeploymentDir + File.separator + fileName);
                try (InputStream is = jar.getInputStream(file);
                     FileOutputStream fos = new FileOutputStream(f);){
                    while (is.available() > 0) {
                        fos.write(is.read());
                    }
                }
                pluginsFiles.add(fileName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pluginsFiles;
    }
}

