/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugins.engine;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.Dependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.plugins.engine.PluginJarProcessor;

@Dependent
public class PluginWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(PluginWatcher.class);
    volatile boolean active;
    private ExecutorService executor;
    private PluginJarProcessor pluginJarProcessor;

    void start(String pluginDir, ExecutorService executor, PluginJarProcessor pluginJarProcessor) throws IOException {
        Path pluginsRootPath = Paths.get(pluginDir, new String[0]);
        if (this.active || !Files.exists(pluginsRootPath, new LinkOption[0])) {
            return;
        }
        this.active = true;
        this.executor = executor;
        this.pluginJarProcessor = pluginJarProcessor;
        WatchService watchService = FileSystems.getDefault().newWatchService();
        pluginsRootPath.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.startWatchService(watchService);
    }

    private void startWatchService(WatchService watchService) {
        this.executor.submit(() -> {
            while (this.active) {
                try {
                    WatchKey watchKey = watchService.poll(5L, TimeUnit.SECONDS);
                    if (watchKey == null || !this.active) continue;
                    List<WatchEvent<?>> events = watchKey.pollEvents();
                    for (WatchEvent<?> event : events) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        Path file = (Path)event.context();
                        if (kind == StandardWatchEventKinds.ENTRY_CREATE || kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                            this.loadPlugins(file);
                            continue;
                        }
                        if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                        this.reloadPlugins(file);
                    }
                    boolean valid = watchKey.reset();
                    if (valid) continue;
                    break;
                }
                catch (InterruptedException e) {
                    this.active = false;
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    void stop() {
        this.active = false;
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    void loadPlugins(Path file) {
        if (file.getFileName().toString().endsWith(".jar")) {
            try {
                this.pluginJarProcessor.loadPlugins(file, true);
            }
            catch (Exception e) {
                this.logPluginsWatcherError("Failed to process new plugin " + file.getFileName().toString(), e, !this.active);
            }
        }
    }

    void reloadPlugins(Path file) {
        try {
            this.pluginJarProcessor.reload();
        }
        catch (Exception e) {
            this.logPluginsWatcherError("Failed to delete plugin " + file.getFileName().toString(), e, !this.active);
        }
    }

    void logPluginsWatcherError(String message, Exception e, boolean debug) {
        if (debug) {
            LOG.debug(message);
        } else {
            LOG.error(message);
        }
    }
}

