/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security.adapter;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.security.auth.Subject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.GroupImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.security.authz.adapter.GroupsAdapter;

@ApplicationScoped
public class WeblogicGroupsAdapter
implements GroupsAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WeblogicGroupsAdapter.class);
    private Class webLogicSecurity;

    public WeblogicGroupsAdapter() {
        try {
            this.webLogicSecurity = Class.forName("weblogic.security.Security");
        }
        catch (Exception e) {
            logger.info("Unable to find weblogic.security.Security, disabling weblogic adapter");
        }
    }

    public List<Group> getGroups(String principal, Object subject) {
        if (this.webLogicSecurity == null) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            Subject wlsSubject = (Subject)subject;
            if (wlsSubject == null) {
                Method method = this.webLogicSecurity.getMethod("getCurrentSubject", new Class[0]);
                wlsSubject = (Subject)method.invoke(null, new Object[0]);
            }
            if (wlsSubject != null) {
                for (Principal p : wlsSubject.getPrincipals()) {
                    if (p.getClass().getName().indexOf("WLSGroup") == -1) continue;
                    groups.add((Group)new GroupImpl(p.getName()));
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to get groups from subject due to {}", (Object)e.getMessage(), (Object)e);
        }
        return groups;
    }
}

