/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.uberfire.ext.editor.commons.file.exports;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.annotation.Generated;

import org.uberfire.annotations.Customizable;
import org.uberfire.preferences.shared.PreferenceScopeResolutionStrategy;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.bean.BasePreferenceBean;
import org.uberfire.preferences.shared.bean.BasePreferencePortable;
import org.uberfire.preferences.shared.bean.PreferenceBeanStore;
import org.uberfire.preferences.shared.impl.PreferenceScopeResolutionStrategyInfo;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
@Generated("org.uberfire.ext.preferences.processors.WorkbenchPreferenceProcessor")
/*
* WARNING! This class is generated. Do not modify.
*/
public class FileExportsPreferencesBeanGeneratedImpl extends FileExportsPreferences implements BasePreferenceBean<FileExportsPreferences> {

    private PreferenceBeanStore store;
    
    private PreferenceScopeResolutionStrategy resolutionStrategy;

    @Inject
    public FileExportsPreferencesBeanGeneratedImpl( final PreferenceBeanStore store,
                               @Customizable final PreferenceScopeResolutionStrategy resolutionStrategy ) {
        this.store = store;
        this.resolutionStrategy = resolutionStrategy;
    }

    @Override
    public void load() {
        load( ( ParameterizedCommand<Throwable> ) null );
    }

    @Override
    public void load( final ParameterizedCommand<Throwable> errorCallback ) {
        load( ( ParameterizedCommand<FileExportsPreferences> ) null, errorCallback );
    }

    @Override
    public void load( final ParameterizedCommand<FileExportsPreferences> successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        final FileExportsPreferencesBeanGeneratedImpl preferenceBean = this;

        store.load( new FileExportsPreferencesPortableGeneratedImpl(),
                    getLoadSuccessCallback( successCallback ),
                    errorCallback );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy ) {
        load( customScopeResolutionStrategy, null );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        load( customScopeResolutionStrategy, null, errorCallback );
    }

    @Override
    public void load( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<FileExportsPreferences> successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        final FileExportsPreferencesBeanGeneratedImpl preferenceBean = this;

        store.load( new FileExportsPreferencesPortableGeneratedImpl(),
                    customScopeResolutionStrategy,
                    getLoadSuccessCallback( successCallback ),
                    errorCallback );
    }

    private ParameterizedCommand<BasePreferencePortable<FileExportsPreferences>> getLoadSuccessCallback( final ParameterizedCommand<FileExportsPreferences> successCallback ) {
        final FileExportsPreferencesBeanGeneratedImpl preferenceBean = this;

        return new ParameterizedCommand<BasePreferencePortable<FileExportsPreferences>>() {
            @Override
            public void execute( final BasePreferencePortable<FileExportsPreferences> portablePreference ) {
                copy( (FileExportsPreferencesPortableGeneratedImpl) portablePreference, preferenceBean );
                if ( successCallback != null ) {
                    successCallback.execute( preferenceBean );
                }
            }
        };
    }

    private void copy( final FileExportsPreferences from,
                       final FileExportsPreferences to ) {
        to.pdfOrientation = from.pdfOrientation;
        to.pdfUnit = from.pdfUnit;
        to.pdfFormat = from.pdfFormat;
    }

    @Override
    public void save() {
        save( ( ParameterizedCommand<Throwable> ) null );
    }

    @Override
    public void save( final ParameterizedCommand<Throwable> errorCallback ) {
        save( ( Command ) null, errorCallback );
    }

    @Override
    public void save( final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    successCallback,
                    errorCallback );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy ) {
        save( customScopeResolutionStrategy, null );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        save( customScopeResolutionStrategy, null, errorCallback );
    }

    @Override
    public void save( final PreferenceScopeResolutionStrategyInfo customScopeResolutionStrategy,
                      final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    customScopeResolutionStrategy,
                    successCallback,
                    errorCallback );
    }

    @Override
    public void save( final PreferenceScope customScope ) {
        save( customScope, null );
    }

    @Override
    public void save( final PreferenceScope customScope,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        save( customScope, null, errorCallback );
    }

    @Override
    public void save( final PreferenceScope customScope,
                      final Command successCallback,
                      final ParameterizedCommand<Throwable> errorCallback ) {
        store.save( createPortableCopy(),
                    customScope,
                    successCallback,
                    errorCallback );
    }

    private BasePreferencePortable<FileExportsPreferences> createPortableCopy() {
        FileExportsPreferencesPortableGeneratedImpl portablePreference = new FileExportsPreferencesPortableGeneratedImpl();

        copy( this, portablePreference );

        return portablePreference;
    }
}
