/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service.restriction;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.ext.editor.commons.service.restriction.PathOperationRestriction;
import org.uberfire.ext.editor.commons.service.restrictor.DeleteRestrictor;
import org.uberfire.ext.editor.commons.service.restrictor.RenameRestrictor;

@ApplicationScoped
public class LockRestrictor
implements DeleteRestrictor,
RenameRestrictor {
    @Inject
    private VFSLockService lockService;
    @Inject
    private User identity;

    public PathOperationRestriction hasRestriction(Path path) {
        final LockInfo lockInfo = this.lockService.retrieveLockInfo(path);
        if (lockInfo != null && lockInfo.isLocked() && !this.identity.getIdentifier().equals(lockInfo.lockedBy())) {
            return new PathOperationRestriction(){

                public String getMessage(Path path) {
                    return path.toURI() + " cannot be deleted, moved or renamed. It is locked by: " + lockInfo.lockedBy();
                }
            };
        }
        final List lockInfos = this.lockService.retrieveLockInfos(path, true);
        if (lockInfos != null && !lockInfos.isEmpty()) {
            return new PathOperationRestriction(){

                public String getMessage(Path path) {
                    return path.toURI() + " cannot be deleted, moved or renamed. It contains the following locked files: " + lockInfos;
                }
            };
        }
        return null;
    }
}

