/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.version;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.file.Path;

public class VersionUtil {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public Path getDotFilePath(Path path) {
        return path.resolveSibling("." + path.getFileName());
    }

    public String getVersion(Path path) {
        if (path instanceof AbstractPath) {
            String host = ((AbstractPath)path).getHost();
            return host.substring(0, host.indexOf("@"));
        }
        return "master";
    }

    public Path getPath(Path path, String version) throws URISyntaxException {
        String authority = path.toUri().getAuthority();
        authority = version + authority.substring(authority.indexOf("@"));
        String scheme = path.getFileSystem().provider().getScheme();
        String rawPath = path.toUri().getRawPath();
        String uri = scheme + "://" + authority + rawPath;
        return this.ioService.get(new URI(uri));
    }

    public String getFileName(Path path) {
        return path.getFileName().toString();
    }
}

