/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.cluster.events;

import java.util.UUID;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.EventMetadata;
import javax.inject.Inject;
import org.jboss.errai.marshalling.server.ServerMarshalling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.cluster.ClusterJMSService;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.cluster.events.ClusterSerializedCDIMessageWrapper;
import org.uberfire.commons.clusterapi.Clustered;
import org.uberfire.commons.services.cdi.Startup;

@Startup
@ApplicationScoped
public class ClusterEventObserver {
    public static final String CHANNEL_NAME = "CLUSTER_CDI_EVENTS";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterEventObserver.class);
    private String nodeId = UUID.randomUUID().toString();
    private Event<Object> eventBus;
    private ClusterService clusterService;

    public ClusterEventObserver() {
    }

    @Inject
    public ClusterEventObserver(Event<Object> eventBus) {
        this.clusterService = new ClusterJMSService();
        this.eventBus = eventBus;
        if (this.clusterService.isAppFormerClustered()) {
            this.clusterService.connect();
            this.clusterService.createConsumer(ClusterService.DestinationType.PubSub, CHANNEL_NAME, ClusterSerializedCDIMessageWrapper.class, message -> this.consumeMessage(eventBus, (ClusterSerializedCDIMessageWrapper)message));
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.clusterService.isAppFormerClustered()) {
            this.clusterService.close();
        }
    }

    ClusterService getClusterService() {
        return this.clusterService;
    }

    void consumeMessage(Event<Object> eventBus, ClusterSerializedCDIMessageWrapper message) {
        if (!message.getNodeId().equals(this.nodeId)) {
            try {
                Object event = this.fromJSON(message);
                eventBus.fire(event);
            }
            catch (Exception e) {
                LOGGER.error("Error consuming cluster event:  " + e.getMessage());
            }
        }
    }

    Object fromJSON(ClusterSerializedCDIMessageWrapper message) {
        return ServerMarshalling.fromJSON((String)message.getJson());
    }

    public void observeAllEvents(@Observes(notifyObserver=Reception.IF_EXISTS) Object event, EventMetadata metaData) {
        if (this.shouldObserveThisEvent(event, metaData)) {
            this.broadcast(event);
        }
    }

    public void broadcast(Object event) {
        if (!this.getClusterService().isAppFormerClustered()) {
            return;
        }
        ClusterSerializedCDIMessageWrapper wrapper = new ClusterSerializedCDIMessageWrapper(this.nodeId, this.toJSON(event), event.getClass().getName());
        this.getClusterService().broadcast(ClusterService.DestinationType.PubSub, CHANNEL_NAME, wrapper);
    }

    String toJSON(Object event) {
        return ServerMarshalling.toJSON((Object)event);
    }

    boolean shouldObserveThisEvent(Object event, EventMetadata metaData) {
        return event.getClass().isAnnotationPresent(Clustered.class) && !this.createdOnThisClass(metaData);
    }

    private boolean createdOnThisClass(EventMetadata metaData) {
        if (metaData == null || metaData.getInjectionPoint() == null) {
            return false;
        }
        return metaData.getInjectionPoint().getBean().getBeanClass().equals(this.getClass());
    }

    String getNodeId() {
        return this.nodeId;
    }
}

