/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.uberfire.commons.lifecycle.PriorityDisposable;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemMetadata;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Option;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.ProviderNotFoundException;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.attribute.FileTime;

public interface IOService
extends PriorityDisposable {
    public static final Set<OpenOption> EMPTY_OPTIONS = new HashSet<OpenOption>();

    public void startBatch(FileSystem var1);

    public void startBatch(FileSystem var1, Option ... var2);

    public void endBatch();

    public FileAttribute<?>[] convert(Map<String, ?> var1);

    public Path get(String var1, String ... var2) throws IllegalArgumentException;

    public Path get(URI var1) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException;

    public Iterable<FileSystemMetadata> getFileSystemMetadata();

    public FileSystem getFileSystem(URI var1) throws IllegalArgumentException, FileSystemNotFoundException, ProviderNotFoundException, SecurityException;

    public FileSystem newFileSystem(URI var1, Map<String, ?> var2) throws IllegalArgumentException, FileSystemAlreadyExistsException, ProviderNotFoundException, IOException, SecurityException;

    public void onNewFileSystem(NewFileSystemListener var1);

    public InputStream newInputStream(Path var1, OpenOption ... var2) throws IllegalArgumentException, NoSuchFileException, UnsupportedOperationException, IOException, SecurityException;

    public OutputStream newOutputStream(Path var1, OpenOption ... var2) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public SeekableByteChannel newByteChannel(Path var1, OpenOption ... var2) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public SeekableByteChannel newByteChannel(Path var1, Set<? extends OpenOption> var2, FileAttribute<?> ... var3) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public DirectoryStream<Path> newDirectoryStream(Path var1) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException;

    public DirectoryStream<Path> newDirectoryStream(Path var1, DirectoryStream.Filter<Path> var2) throws IllegalArgumentException, NotDirectoryException, IOException, SecurityException;

    public Path createFile(Path var1, FileAttribute<?> ... var2) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public Path createDirectory(Path var1, FileAttribute<?> ... var2) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public Path createDirectories(Path var1, FileAttribute<?> ... var2) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public Path createDirectory(Path var1, Map<String, ?> var2) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public Path createDirectories(Path var1, Map<String, ?> var2) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException;

    public void delete(Path var1, DeleteOption ... var2) throws IllegalArgumentException, NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException;

    public boolean deleteIfExists(Path var1, DeleteOption ... var2) throws IllegalArgumentException, DirectoryNotEmptyException, IOException, SecurityException;

    public Path createTempFile(String var1, String var2, FileAttribute<?> ... var3) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public Path createTempFile(Path var1, String var2, String var3, FileAttribute<?> ... var4) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public Path createTempDirectory(String var1, FileAttribute<?> ... var2) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public Path createTempDirectory(Path var1, String var2, FileAttribute<?> ... var3) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException;

    public Path copy(Path var1, Path var2, CopyOption ... var3) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException;

    public Path move(Path var1, Path var2, CopyOption ... var3) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException;

    public <V extends FileAttributeView> V getFileAttributeView(Path var1, Class<V> var2) throws IllegalArgumentException;

    public Map<String, Object> readAttributes(Path var1) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException;

    public Map<String, Object> readAttributes(Path var1, String var2) throws UnsupportedOperationException, NoSuchFileException, IllegalArgumentException, IOException, SecurityException;

    public Path setAttributes(Path var1, FileAttribute<?> ... var2) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException;

    public Path setAttributes(Path var1, Map<String, Object> var2) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException;

    public Path setAttribute(Path var1, String var2, Object var3) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException;

    public Object getAttribute(Path var1, String var2) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException;

    public FileTime getLastModifiedTime(Path var1) throws IllegalArgumentException, IOException, SecurityException;

    public long size(Path var1) throws IllegalArgumentException, IOException, SecurityException;

    public boolean exists(Path var1) throws IllegalArgumentException, SecurityException;

    public boolean notExists(Path var1) throws IllegalArgumentException, SecurityException;

    public boolean isSameFile(Path var1, Path var2) throws IllegalArgumentException, IOException, SecurityException;

    public BufferedReader newBufferedReader(Path var1, Charset var2) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException;

    public BufferedWriter newBufferedWriter(Path var1, Charset var2, OpenOption ... var3) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException;

    public long copy(InputStream var1, Path var2, CopyOption ... var3) throws IOException, FileAlreadyExistsException, DirectoryNotEmptyException, UnsupportedOperationException, SecurityException;

    public long copy(Path var1, OutputStream var2) throws IOException, SecurityException;

    public byte[] readAllBytes(Path var1) throws IOException, OutOfMemoryError, SecurityException;

    public List<String> readAllLines(Path var1) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException;

    public List<String> readAllLines(Path var1, Charset var2) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException;

    public String readAllString(Path var1, Charset var2) throws IllegalArgumentException, NoSuchFileException, IOException;

    public String readAllString(Path var1) throws IllegalArgumentException, NoSuchFileException, IOException;

    public Path write(Path var1, byte[] var2, OpenOption ... var3) throws IOException, UnsupportedOperationException, SecurityException;

    public Path write(Path var1, byte[] var2, Map<String, ?> var3, OpenOption ... var4) throws IOException, UnsupportedOperationException, SecurityException;

    public Path write(Path var1, byte[] var2, Set<? extends OpenOption> var3, FileAttribute<?> ... var4) throws IllegalArgumentException, IOException, UnsupportedOperationException;

    public Path write(Path var1, Iterable<? extends CharSequence> var2, Charset var3, OpenOption ... var4) throws IllegalArgumentException, IOException, UnsupportedOperationException, SecurityException;

    public Path write(Path var1, String var2, OpenOption ... var3) throws IllegalArgumentException, IOException, UnsupportedOperationException;

    public Path write(Path var1, String var2, Charset var3, OpenOption ... var4) throws IllegalArgumentException, IOException, UnsupportedOperationException;

    public Path write(Path var1, String var2, Set<? extends OpenOption> var3, FileAttribute<?> ... var4) throws IllegalArgumentException, IOException, UnsupportedOperationException;

    public Path write(Path var1, String var2, Charset var3, Set<? extends OpenOption> var4, FileAttribute<?> ... var5) throws IllegalArgumentException, IOException, UnsupportedOperationException;

    public Path write(Path var1, String var2, Map<String, ?> var3, OpenOption ... var4) throws IllegalArgumentException, IOException, UnsupportedOperationException;

    public Path write(Path var1, String var2, Charset var3, Map<String, ?> var4, OpenOption ... var5) throws IllegalArgumentException, IOException, UnsupportedOperationException;

    public static abstract class NewFileSystemListener {
        public abstract void execute(FileSystem var1, String var2, String var3, Map<String, ?> var4);
    }
}

