/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.io.attribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.commons.data.Pair;
import org.uberfire.io.attribute.DublinCoreAttributes;
import org.uberfire.io.attribute.DublinCoreAttributesUtil;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractBasicFileAttributeView;
import org.uberfire.java.nio.base.AbstractPath;
import org.uberfire.java.nio.base.NeedsPreloadedAttrs;
import org.uberfire.java.nio.base.NotImplementedException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileTime;

public class DublinCoreView
extends AbstractBasicFileAttributeView<AbstractPath>
implements NeedsPreloadedAttrs {
    static final String TITLE = "dcore.title";
    static final String CREATOR = "dcore.creator";
    static final String SUBJECT = "dcore.subject";
    static final String DESCRIPTION = "dcore.description";
    static final String PUBLISHER = "dcore.publisher";
    static final String CONTRIBUTOR = "dcore.contributor";
    static final String TYPE = "dcore.type";
    static final String FORMAT = "dcore.format";
    static final String IDENTIFIER = "dcore.identifier";
    static final String SOURCE = "dcore.source";
    static final String LANGUAGE = "dcore.language";
    static final String RELATION = "dcore.relation";
    static final String COVERAGE = "dcore.coverage";
    static final String RIGHTS = "dcore.rights";
    static final String LAST_MODIFIED_TIME = "lastModifiedTime";
    static final String LAST_ACCESS_TIME = "lastAccessTime";
    static final String CREATION_TIME = "creationTime";
    private static final Set<String> PROPERTIES = new HashSet<String>(){
        {
            this.add(DublinCoreView.TITLE);
            this.add(DublinCoreView.CREATOR);
            this.add(DublinCoreView.SUBJECT);
            this.add(DublinCoreView.DESCRIPTION);
            this.add(DublinCoreView.PUBLISHER);
            this.add(DublinCoreView.CONTRIBUTOR);
            this.add(DublinCoreView.TYPE);
            this.add(DublinCoreView.FORMAT);
            this.add(DublinCoreView.IDENTIFIER);
            this.add(DublinCoreView.SOURCE);
            this.add(DublinCoreView.LANGUAGE);
            this.add(DublinCoreView.RELATION);
            this.add(DublinCoreView.COVERAGE);
            this.add(DublinCoreView.RIGHTS);
        }
    };
    private final DublinCoreAttributes attrs;

    public DublinCoreView(AbstractPath path) {
        super((Path)path);
        Map content = path.getAttrStorage().getContent();
        final BasicFileAttributes fileAttrs = ((BasicFileAttributeView)path.getFileSystem().provider().getFileAttributeView((Path)path, BasicFileAttributeView.class, new LinkOption[0])).readAttributes();
        final HashMap<String, List<String>> dcore = new HashMap<String, List<String>>(){
            {
                for (String property : PROPERTIES) {
                    this.put(property, new ArrayList());
                }
            }
        };
        for (Map.Entry<String, Object> entry : content.entrySet()) {
            Pair<Integer, String> result;
            if (((String)entry.getKey()).startsWith(TITLE)) {
                result = this.extractValue(entry);
                ((List)dcore.get(TITLE)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (((String)entry.getKey()).startsWith(CREATOR)) {
                result = this.extractValue(entry);
                ((List)dcore.get(CREATOR)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(SUBJECT)) {
                result = this.extractValue(entry);
                ((List)dcore.get(SUBJECT)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(DESCRIPTION)) {
                result = this.extractValue(entry);
                ((List)dcore.get(DESCRIPTION)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(PUBLISHER)) {
                result = this.extractValue(entry);
                ((List)dcore.get(PUBLISHER)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(CONTRIBUTOR)) {
                result = this.extractValue(entry);
                ((List)dcore.get(CONTRIBUTOR)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(TYPE)) {
                result = this.extractValue(entry);
                ((List)dcore.get(TYPE)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(FORMAT)) {
                result = this.extractValue(entry);
                ((List)dcore.get(FORMAT)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(IDENTIFIER)) {
                result = this.extractValue(entry);
                ((List)dcore.get(IDENTIFIER)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(SOURCE)) {
                result = this.extractValue(entry);
                ((List)dcore.get(SOURCE)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(LANGUAGE)) {
                result = this.extractValue(entry);
                ((List)dcore.get(LANGUAGE)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(RELATION)) {
                result = this.extractValue(entry);
                ((List)dcore.get(RELATION)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (entry.getKey().startsWith(COVERAGE)) {
                result = this.extractValue(entry);
                ((List)dcore.get(COVERAGE)).add((Integer)result.getK1(), (String)result.getK2());
                continue;
            }
            if (!entry.getKey().startsWith(RIGHTS)) continue;
            result = this.extractValue(entry);
            ((List)dcore.get(RIGHTS)).add((Integer)result.getK1(), (String)result.getK2());
        }
        this.attrs = new DublinCoreAttributes(){

            @Override
            public List<String> titles() {
                return (List)dcore.get(DublinCoreView.TITLE);
            }

            @Override
            public List<String> creators() {
                return (List)dcore.get(DublinCoreView.CREATOR);
            }

            @Override
            public List<String> subjects() {
                return (List)dcore.get(DublinCoreView.SUBJECT);
            }

            @Override
            public List<String> descriptions() {
                return (List)dcore.get(DublinCoreView.DESCRIPTION);
            }

            @Override
            public List<String> publishers() {
                return (List)dcore.get(DublinCoreView.PUBLISHER);
            }

            @Override
            public List<String> contributors() {
                return (List)dcore.get(DublinCoreView.CONTRIBUTOR);
            }

            @Override
            public List<String> types() {
                return (List)dcore.get(DublinCoreView.TYPE);
            }

            @Override
            public List<String> formats() {
                return (List)dcore.get(DublinCoreView.FORMAT);
            }

            @Override
            public List<String> identifiers() {
                return (List)dcore.get(DublinCoreView.IDENTIFIER);
            }

            @Override
            public List<String> sources() {
                return (List)dcore.get(DublinCoreView.SOURCE);
            }

            @Override
            public List<String> languages() {
                return (List)dcore.get(DublinCoreView.LANGUAGE);
            }

            @Override
            public List<String> relations() {
                return (List)dcore.get(DublinCoreView.RELATION);
            }

            @Override
            public List<String> coverages() {
                return (List)dcore.get(DublinCoreView.COVERAGE);
            }

            @Override
            public List<String> rights() {
                return (List)dcore.get(DublinCoreView.RIGHTS);
            }

            public FileTime lastModifiedTime() {
                return fileAttrs.lastModifiedTime();
            }

            public FileTime lastAccessTime() {
                return fileAttrs.lastAccessTime();
            }

            public FileTime creationTime() {
                return fileAttrs.creationTime();
            }

            public boolean isRegularFile() {
                return fileAttrs.isRegularFile();
            }

            public boolean isDirectory() {
                return fileAttrs.isDirectory();
            }

            public boolean isSymbolicLink() {
                return fileAttrs.isSymbolicLink();
            }

            public boolean isOther() {
                return fileAttrs.isOther();
            }

            public long size() {
                return fileAttrs.size();
            }

            public Object fileKey() {
                return fileAttrs.fileKey();
            }
        };
    }

    private Pair<Integer, String> extractValue(Map.Entry<String, Object> entry) {
        int start = entry.getKey().indexOf(91);
        if (start < 0) {
            return Pair.newPair((Object)0, (Object)entry.getValue().toString());
        }
        int end = entry.getKey().indexOf(93);
        return Pair.newPair((Object)Integer.valueOf(entry.getKey().substring(start + 1, end)), (Object)entry.getValue().toString());
    }

    public String name() {
        return "dcore";
    }

    public DublinCoreAttributes readAttributes() throws IOException {
        return this.attrs;
    }

    public Map<String, Object> readAttributes(String ... attributes) {
        return DublinCoreAttributesUtil.toMap(this.readAttributes(), attributes);
    }

    public Class<? extends BasicFileAttributeView>[] viewTypes() {
        return new Class[]{DublinCoreView.class};
    }

    public void setAttribute(String attribute, Object value) throws IOException {
        PortablePreconditions.checkNotEmpty((String)"attribute", (String)attribute);
        PortablePreconditions.checkCondition((String)"invalid attribute", (boolean)PROPERTIES.contains(attribute));
        throw new NotImplementedException();
    }
}

