/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import org.kie.soup.commons.validation.PortablePreconditions;

public class HyperLinkCell
extends AbstractCell<HyperLink> {
    private static HyperLinkTemplate hyperLinkTemplate = (HyperLinkTemplate)GWT.create(HyperLinkTemplate.class);
    private static TextTemplate textTemplate = (TextTemplate)GWT.create(TextTemplate.class);

    public HyperLinkCell() {
        super(new String[]{"click", "keydown"});
    }

    public void onBrowserEvent(Cell.Context context, Element parent, HyperLink value, NativeEvent event, ValueUpdater<HyperLink> valueUpdater) {
        super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
        if ("click".equals(event.getType())) {
            this.onEnterKeyDown(context, parent, value, event, valueUpdater);
        }
    }

    protected void onEnterKeyDown(Cell.Context context, Element parent, HyperLink value, NativeEvent event, ValueUpdater<HyperLink> valueUpdater) {
        Element element = (Element)event.getEventTarget().cast();
        if (!parent.getFirstChildElement().equals((Object)element)) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        if (valueUpdater != null) {
            valueUpdater.update((Object)value);
        }
    }

    public void render(Cell.Context context, HyperLink value, SafeHtmlBuilder sb) {
        if (value != null) {
            if (value.isLink()) {
                sb.append(hyperLinkTemplate.hyperLink(SafeHtmlUtils.fromString((String)value.getLabel()), value.getLabel()));
            } else {
                sb.append(textTemplate.text(value.getLabel(), value.getLabel()));
            }
        }
    }

    public static class HyperLink {
        private String label;
        private boolean isLink;

        public static HyperLink newLink(String label) {
            return new HyperLink(label, true);
        }

        public static HyperLink newText(String label) {
            return new HyperLink(label, false);
        }

        private HyperLink(String label, boolean isLink) {
            this.label = (String)PortablePreconditions.checkNotNull((String)"label", (Object)label);
            this.isLink = (Boolean)PortablePreconditions.checkNotNull((String)"isLink", (Object)isLink);
        }

        public String getLabel() {
            return this.label;
        }

        public boolean isLink() {
            return this.isLink;
        }
    }

    static interface TextTemplate
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<span title=\"{1}\">{0}</span>")
        public SafeHtml text(String var1, String var2);
    }

    static interface HyperLinkTemplate
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<a title=\"{1}\" href=\"#\">{0}</a>")
        public SafeHtml hyperLink(SafeHtml var1, String var2);
    }
}

