/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.metadata.engine.IndexerScheduler;
import org.uberfire.ext.metadata.event.IndexEvent;

public class ConstrainedIndexerScheduler
implements IndexerScheduler {
    private static final Logger logger = LoggerFactory.getLogger(ConstrainedIndexerScheduler.class);
    private final OrderingGraph<JobNode> graph;

    private ConstrainedIndexerScheduler(OrderingGraph<JobNode> graph) {
        this.graph = graph;
    }

    public Stream<CompletableFuture<Pair<String, List<IndexEvent>>>> schedule(ExecutorService executor) {
        HashMap createdJobs = new HashMap();
        return this.graph.nodesById.values().stream().sorted(Comparator.comparingInt(node -> node.priority)).map(node -> node.id).map(id -> this.schedule(executor, createdJobs, (String)id));
    }

    private CompletableFuture<Pair<String, List<IndexEvent>>> schedule(ExecutorService executor, Map<String, CompletableFuture<Pair<String, List<IndexEvent>>>> createdJobs, String id) {
        if (createdJobs.containsKey(id)) {
            logger.debug("Job [{}] already scheduled. Returning future.", (Object)id);
            return createdJobs.get(id);
        }
        logger.debug("Job [{}] not yet scheduled.", (Object)id);
        JobNode jobNode = (JobNode)this.graph.nodesById.get(id);
        CompletableFuture[] dependencies = (CompletableFuture[])this.graph.edgesById.get(id).stream().filter(constraint -> constraint.isFrom(id)).map(constraint -> ((Constraint)constraint).to).map(dependencyId -> this.schedule(executor, createdJobs, (String)dependencyId)).toArray(CompletableFuture[]::new);
        logger.debug("Dependencies scheduled. Scheduling job for [{}].", (Object)id);
        CompletionStage jobFuture = CompletableFuture.allOf(dependencies).thenCompose(ignore -> CompletableFuture.supplyAsync(jobNode.job, executor).thenApply(events -> Pair.newPair((Object)jobNode.id, (Object)events)));
        createdJobs.put(id, (CompletableFuture<Pair<String, List<IndexEvent>>>)jobFuture);
        return jobFuture;
    }

    private static class SchedulerFactory
    implements IndexerScheduler.Factory {
        private final OrderingGraph<OrderingNode> graph;

        SchedulerFactory(OrderingGraph<OrderingNode> graph) {
            this.graph = graph;
        }

        public IndexerScheduler create(Map<String, ? extends Supplier<List<IndexEvent>>> jobsByIndexerId) {
            OrderingGraph jobGraph = new OrderingGraph();
            HashSet missingJobs = new HashSet();
            jobsByIndexerId.forEach((id, job) -> {
                int priority = Optional.ofNullable((OrderingNode)this.graph.nodesById.get(id)).map(node -> node.priority).orElse(0);
                jobGraph.nodesById.put((String)id, new JobNode((String)id, priority, (Supplier<List<IndexEvent>>)job));
                List<Constraint> constraints = this.graph.edgesById.getOrDefault(id, Collections.emptyList());
                this.findMissingDependencies(jobsByIndexerId, missingJobs, (String)id, constraints);
                this.copyValidConstraints(jobsByIndexerId, jobGraph, (String)id, constraints);
            });
            if (missingJobs.isEmpty()) {
                return new ConstrainedIndexerScheduler(jobGraph);
            }
            throw new IllegalArgumentException("Cannot schedule jobs without missing dependencies: " + missingJobs);
        }

        private void copyValidConstraints(Map<String, ? extends Supplier<List<IndexEvent>>> jobsByIndexerId, OrderingGraph<JobNode> jobGraph, String id, List<Constraint> constraints) {
            constraints.stream().filter(c -> jobsByIndexerId.containsKey(((Constraint)c).from) && jobsByIndexerId.containsKey(((Constraint)c).to)).collect(Collectors.toCollection(() -> jobGraph.edgesById.computeIfAbsent(id, ignore -> new ArrayList())));
        }

        private void findMissingDependencies(Map<String, ? extends Supplier<List<IndexEvent>>> jobsByIndexerId, Set<String> missingJobs, String id, List<Constraint> constraints) {
            constraints.stream().filter(c -> c.isFrom(id) && !jobsByIndexerId.containsKey(((Constraint)c).to)).map(c -> ((Constraint)c).to).collect(Collectors.toCollection(() -> missingJobs));
        }
    }

    public static class ConstraintBuilder {
        Map<String, Integer> priorities = new HashMap<String, Integer>();
        Map<String, List<Constraint>> constraints = new HashMap<String, List<Constraint>>();

        public ConstraintBuilder addPriority(String indexerId, int priority) {
            this.priorities.put(indexerId, priority);
            this.constraints.computeIfAbsent(indexerId, id -> new ArrayList());
            return this;
        }

        public ConstraintBuilder addConstraint(String fromIndexerId, String toIndexerId) {
            Constraint constraint = new Constraint(fromIndexerId, toIndexerId);
            this.constraints.computeIfAbsent(fromIndexerId, id -> new ArrayList()).add(constraint);
            this.constraints.computeIfAbsent(toIndexerId, id -> new ArrayList()).add(constraint);
            return this;
        }

        public IndexerScheduler.Factory createFactory() {
            HashSet<String> visited = new HashSet<String>();
            LinkedHashSet<String> visiting = new LinkedHashSet<String>();
            OrderingGraph<OrderingNode> graph = new OrderingGraph<OrderingNode>();
            this.populateAndValidateGraph(graph, visited, visiting);
            return new SchedulerFactory(graph);
        }

        private void populateAndValidateGraph(OrderingGraph<OrderingNode> graph, Set<String> visited, Set<String> visiting) {
            for (String id : this.constraints.keySet()) {
                this.populateAndValidateGraph(graph, visited, visiting, id);
            }
        }

        private void populateAndValidateGraph(OrderingGraph<OrderingNode> graph, Set<String> visited, Set<String> visiting, String id) {
            if (visiting.contains(id)) {
                throw new IllegalArgumentException("Cannot have cycles in constraints: " + visiting);
            }
            if (!visited.contains(id)) {
                visiting.add(id);
                graph.nodesById.put(id, new OrderingNode(id, this.priorities.getOrDefault(id, 0)));
                this.constraints.get(id).stream().filter(constraint -> constraint.isFrom(id)).forEach(constraint -> {
                    graph.edgesById.computeIfAbsent(id, ignore -> new ArrayList()).add(constraint);
                    this.populateAndValidateGraph(graph, visited, visiting, ((Constraint)constraint).to);
                });
                visiting.remove(id);
                visited.add(id);
            }
        }
    }

    private static class Constraint {
        private final String from;
        private final String to;

        Constraint(String from, String to) {
            this.from = from;
            this.to = to;
        }

        boolean isFrom(String id) {
            return this.from.equals(id);
        }
    }

    private static class OrderingGraph<T> {
        final Map<String, List<Constraint>> edgesById = new HashMap<String, List<Constraint>>();
        final Map<String, T> nodesById = new HashMap<String, T>();

        private OrderingGraph() {
        }
    }

    private static class JobNode
    extends OrderingNode {
        final Supplier<List<IndexEvent>> job;

        JobNode(String id, int priority, Supplier<List<IndexEvent>> job) {
            super(id, priority);
            this.job = job;
        }
    }

    private static class OrderingNode {
        final String id;
        final int priority;

        OrderingNode(String id, int priority) {
            this.id = id;
            this.priority = priority;
        }
    }
}

