/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.function.Consumer;
import java.util.function.Function;
import org.uberfire.java.nio.file.Path;

public abstract class IndexableIOEvent {
    private final Kind kind;

    private IndexableIOEvent(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public abstract void consume(Consumer<NewFileEvent> var1, Consumer<RenamedFileEvent> var2, Consumer<DeletedFileEvent> var3);

    public abstract <T> T apply(Function<NewFileEvent, T> var1, Function<RenamedFileEvent, T> var2, Function<DeletedFileEvent, T> var3);

    public static enum Kind {
        NewFile,
        RenamedFile,
        DeletedFile;

    }

    public static class DeletedFileEvent
    extends IndexableIOEvent {
        private final Path file;

        public DeletedFileEvent(Path file) {
            super(Kind.DeletedFile);
            this.file = file;
        }

        public Path getFile() {
            return this.file;
        }

        @Override
        public void consume(Consumer<NewFileEvent> newFileConsumer, Consumer<RenamedFileEvent> renameConsumer, Consumer<DeletedFileEvent> deleteConsumer) {
            deleteConsumer.accept(this);
        }

        @Override
        public <T> T apply(Function<NewFileEvent, T> newHandler, Function<RenamedFileEvent, T> renameHandler, Function<DeletedFileEvent, T> deleteHandler) {
            return deleteHandler.apply(this);
        }

        public String toString() {
            return "DeletedFileEvent [file=" + this.file + "]";
        }
    }

    public static class RenamedFileEvent
    extends IndexableIOEvent {
        private final Path newPath;
        private final Path oldPath;

        public RenamedFileEvent(Path oldPath, Path newPath) {
            super(Kind.RenamedFile);
            this.oldPath = oldPath;
            this.newPath = newPath;
        }

        public Path getOldPath() {
            return this.oldPath;
        }

        public Path getNewPath() {
            return this.newPath;
        }

        @Override
        public void consume(Consumer<NewFileEvent> newFileConsumer, Consumer<RenamedFileEvent> renameConsumer, Consumer<DeletedFileEvent> deleteConsumer) {
            renameConsumer.accept(this);
        }

        @Override
        public <T> T apply(Function<NewFileEvent, T> newHandler, Function<RenamedFileEvent, T> renameHandler, Function<DeletedFileEvent, T> deleteHandler) {
            return renameHandler.apply(this);
        }

        public String toString() {
            return "RenamedFileEvent [newPath=" + this.newPath + ", oldPath=" + this.oldPath + "]";
        }
    }

    public static class NewFileEvent
    extends IndexableIOEvent {
        private final Path file;

        public NewFileEvent(Path file) {
            super(Kind.NewFile);
            this.file = file;
        }

        public Path getFile() {
            return this.file;
        }

        @Override
        public void consume(Consumer<NewFileEvent> newFileConsumer, Consumer<RenamedFileEvent> renameConsumer, Consumer<DeletedFileEvent> deleteConsumer) {
            newFileConsumer.accept(this);
        }

        @Override
        public <T> T apply(Function<NewFileEvent, T> newHandler, Function<RenamedFileEvent, T> renameHandler, Function<DeletedFileEvent, T> deleteHandler) {
            return newHandler.apply(this);
        }

        public String toString() {
            return "NewFileEvent [file=" + this.file + "]";
        }
    }
}

