/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.file.api;

import java.util.Properties;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public class FileSystemUtils {
    public static final String CFG_KIE_CONTROLLER_OCP_ENABLED = "org.kie.server.controller.openshift.enabled";
    public static final String SIMPLIFIED_MONITORING_ENABLED = "org.appformer.server.simplified.monitoring.enabled";
    public static final String K8S_FS_SCHEME = "k8s";
    private static final String GIT_FS_SCHEME = "git";
    private static ThreadLocal<Properties> configProps = ThreadLocal.withInitial(System::getProperties);

    private FileSystemUtils() {
    }

    public static Properties getConfigProps() {
        return configProps.get();
    }

    public static boolean isOpenShiftSupported() {
        return "true".equals(FileSystemUtils.getConfigProps().getProperty(CFG_KIE_CONTROLLER_OCP_ENABLED, "false"));
    }

    public static boolean isSimplifiedMonitoringEnabled() {
        return "true".equals(FileSystemUtils.getConfigProps().getProperty(SIMPLIFIED_MONITORING_ENABLED, "false"));
    }

    public static boolean isGitDefaultFileSystem() {
        return FileSystemProviders.getDefaultProvider().getScheme().equals(GIT_FS_SCHEME);
    }

    public static boolean isK8SFileSystemProviderAsDefault(FileSystemProvider provider) {
        return K8S_FS_SCHEME.equals(provider.getScheme()) && FileSystemUtils.isOpenShiftSupported() && FileSystemUtils.isSimplifiedMonitoringEnabled();
    }
}

