/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.http;

import java.net.URI;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;
import org.eclipse.jgit.http.server.GitServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.api.FileSystemProviders;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

@WebListener
public class HTTPSupport
implements ServletContextListener {
    private static final String GIT_PATH = "git";
    private static final Logger LOG = LoggerFactory.getLogger(HTTPSupport.class);
    private ServletContext servletContext = null;

    public void contextInitialized(ServletContextEvent sce) {
        this.servletContext = sce.getServletContext();
        JGitFileSystemProvider fsProvider = this.resolveProvider();
        if (fsProvider != null && (fsProvider.getConfig().isHttpEnabled() || fsProvider.getConfig().isHttpsEnabled())) {
            if (fsProvider.getConfig().isHttpEnabled()) {
                fsProvider.addHostName("http", fsProvider.getConfig().getHttpHostName() + ":" + fsProvider.getConfig().getHttpPort() + this.servletContext.getContextPath() + "/" + GIT_PATH);
            }
            if (fsProvider.getConfig().isHttpsEnabled()) {
                fsProvider.addHostName("https", fsProvider.getConfig().getHttpsHostName() + ":" + fsProvider.getConfig().getHttpsPort() + this.servletContext.getContextPath() + "/" + GIT_PATH);
            }
            fsProvider.updateCacheWithHostNames();
            GitServlet gitServlet = new GitServlet();
            gitServlet.setRepositoryResolver(fsProvider.getRepositoryResolver());
            gitServlet.setAsIsFileService(null);
            gitServlet.setReceivePackFactory((req, db) -> fsProvider.getReceivePack("http", req, db));
            ServletRegistration.Dynamic sd = this.servletContext.addServlet("GitServlet", (Servlet)gitServlet);
            sd.addMapping(new String[]{"/git/*"});
            sd.setLoadOnStartup(1);
            sd.setAsyncSupported(false);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.servletContext = null;
    }

    protected JGitFileSystemProvider resolveProvider() {
        try {
            return (JGitFileSystemProvider)FileSystemProviders.resolveProvider((URI)URI.create("git://whatever"));
        }
        catch (Exception ex) {
            LOG.error("Error trying to resolve JGitFileSystemProvider.", (Throwable)ex);
            return null;
        }
    }
}

