/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.daemon.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProvider;

public abstract class BaseGitCommand
implements Command,
ServerSessionAware,
Runnable {
    public static final AttributeRepository.AttributeKey<User> SUBJECT_KEY = new AttributeRepository.AttributeKey();
    protected final String command;
    protected final String repositoryName;
    protected final RepositoryResolver repositoryResolver;
    private final ExecutorService executorService;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private User user;

    public BaseGitCommand(String command, JGitFileSystemProvider.RepositoryResolverImpl repositoryResolver, ExecutorService executorService) {
        this.command = command;
        this.repositoryName = this.buildRepositoryName(command);
        this.repositoryResolver = repositoryResolver;
        this.executorService = executorService;
    }

    private String buildRepositoryName(String command) {
        int start = this.getCommandName().length() + 2;
        String temp = command.substring(start);
        return temp.substring(0, temp.indexOf("'"));
    }

    protected abstract String getCommandName();

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
        if (out instanceof ChannelOutputStream) {
            ((ChannelOutputStream)out).setNoDelay(true);
        }
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
        if (err instanceof ChannelOutputStream) {
            ((ChannelOutputStream)err).setNoDelay(true);
        }
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void start(ChannelSession channel, Environment env) throws IOException {
        this.executorService.execute((Runnable)new DescriptiveRunnable(){

            public String getDescription() {
                return "Git Command [" + this.getClass().getName() + "]";
            }

            public void run() {
                BaseGitCommand.this.run();
            }
        });
    }

    @Override
    public void run() {
        try {
            Repository repository = this.openRepository(this.repositoryName);
            this.execute(repository, this.in, this.out, this.err);
        }
        catch (Throwable e) {
            try {
                this.err.write(e.getMessage().getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.callback != null) {
            this.callback.onExit(0);
        }
    }

    private Repository openRepository(String name) throws ServiceMayNotContinueException {
        if (!(name = name.replace('\\', '/')).startsWith("/")) {
            return null;
        }
        try {
            return this.repositoryResolver.open((Object)this, name.substring(1));
        }
        catch (RepositoryNotFoundException e) {
            return null;
        }
        catch (ServiceNotAuthorizedException e) {
            return null;
        }
        catch (ServiceNotEnabledException e) {
            return null;
        }
    }

    protected abstract void execute(Repository var1, InputStream var2, OutputStream var3, OutputStream var4);

    public void destroy(ChannelSession channel) throws Exception {
    }

    public User getUser() {
        return this.user;
    }

    public void setSession(ServerSession session) {
        this.user = (User)session.getAttribute(SUBJECT_KEY);
    }
}

