/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class GetCommonAncestorCommit {
    private final Git git;
    private final RevCommit commitA;
    private final RevCommit commitB;

    public GetCommonAncestorCommit(Git git, RevCommit commitA, RevCommit commitB) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.commitA = (RevCommit)PortablePreconditions.checkNotNull((String)"commitA", (Object)commitA);
        this.commitB = (RevCommit)PortablePreconditions.checkNotNull((String)"commitB", (Object)commitB);
    }

    public RevCommit execute() {
        RevCommit revCommit;
        RevWalk revWalk = new RevWalk(this.git.getRepository());
        try {
            RevCommit validatedCommitA = revWalk.lookupCommit((AnyObjectId)this.commitA);
            RevCommit validatedCommitB = revWalk.lookupCommit((AnyObjectId)this.commitB);
            revWalk.setRevFilter(RevFilter.MERGE_BASE);
            revWalk.markStart(validatedCommitA);
            revWalk.markStart(validatedCommitB);
            revCommit = revWalk.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    revWalk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new GitException("Error when trying to get common ancestor", e);
            }
        }
        revWalk.close();
        return revCommit;
    }
}

