/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.BranchUtil;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.DefaultCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.MergeCommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.MessageCommitInfo;

public class Merge {
    private Logger logger = LoggerFactory.getLogger(Merge.class);
    private final Git git;
    private final String sourceBranch;
    private final String targetBranch;
    private final boolean noFastForward;
    private final boolean squash;
    private final CommitInfo commitInfo;

    public Merge(Git git, String sourceBranch, String targetBranch) {
        this(git, sourceBranch, targetBranch, false, false, MessageCommitInfo.createMergeMessage(sourceBranch));
    }

    public Merge(Git git, String sourceBranch, String targetBranch, boolean noFastForward, boolean squash, CommitInfo commitInfo) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.sourceBranch = PortablePreconditions.checkNotEmpty((String)"sourceBranch", (String)sourceBranch);
        this.targetBranch = PortablePreconditions.checkNotEmpty((String)"targetBranch", (String)targetBranch);
        this.noFastForward = noFastForward;
        this.squash = squash;
        this.commitInfo = (CommitInfo)PortablePreconditions.checkNotNull((String)"commitInfo", (Object)commitInfo);
    }

    public List<String> execute() {
        BranchUtil.existsBranch(this.git, this.sourceBranch);
        BranchUtil.existsBranch(this.git, this.targetBranch);
        RevCommit lastSourceCommit = this.git.getLastCommit(this.sourceBranch);
        RevCommit lastTargetCommit = this.git.getLastCommit(this.targetBranch);
        RevCommit commonAncestor = this.git.getCommonAncestorCommit(this.sourceBranch, this.targetBranch);
        this.canMerge(this.git.getRepository(), commonAncestor, lastSourceCommit, lastTargetCommit, this.sourceBranch, this.targetBranch);
        return this.proceedMerge(commonAncestor, lastSourceCommit, lastTargetCommit);
    }

    private List<String> proceedMerge(RevCommit commonAncestor, RevCommit lastSourceCommit, RevCommit lastTargetCommit) {
        List diffBetweenBranches;
        List<DiffEntry> diffBetweenCommits = this.git.listDiffs(commonAncestor.getName(), lastSourceCommit.getName());
        List<Object> list = diffBetweenBranches = diffBetweenCommits.isEmpty() ? Collections.emptyList() : this.git.listDiffs(this.git.getTreeFromRef(this.targetBranch), this.git.getTreeFromRef(this.sourceBranch));
        if (diffBetweenBranches.isEmpty()) {
            this.logger.info("There is nothing to merge from branch {} to {}", (Object)this.sourceBranch, (Object)this.targetBranch);
            return Collections.emptyList();
        }
        List<RevCommit> targetCommits = this.git.listCommits((ObjectId)commonAncestor, (ObjectId)lastTargetCommit);
        return targetCommits.isEmpty() && !this.noFastForward ? this.doFastForward(commonAncestor, lastSourceCommit) : this.doMerge(commonAncestor, lastSourceCommit, lastTargetCommit);
    }

    private void canMerge(Repository repo, RevCommit commonAncestor, RevCommit sourceCommitTree, RevCommit targetCommitTree, String sourceBranch, String targetBranch) {
        try {
            ThreeWayMerger merger = MergeStrategy.RECURSIVE.newMerger(repo, true);
            merger.setBase((AnyObjectId)commonAncestor);
            boolean canMerge = merger.merge(new AnyObjectId[]{sourceCommitTree, targetCommitTree});
            if (!canMerge) {
                throw new GitException(String.format("Cannot merge branches from <%s> to <%s>, merge conflicts", sourceBranch, targetBranch));
            }
        }
        catch (IOException e) {
            throw new GitException(String.format("Cannot merge branches from <%s> to <%s>, merge conflicts", sourceBranch, targetBranch), e);
        }
    }

    private List<String> doFastForward(RevCommit commonAncestor, RevCommit lastSourceCommit) {
        List<RevCommit> sourceCommits = this.git.listCommits((ObjectId)commonAncestor, (ObjectId)lastSourceCommit);
        Collections.reverse(sourceCommits);
        String[] commitsIDs = (String[])sourceCommits.stream().map(AnyObjectId::getName).toArray(String[]::new);
        this.git.cherryPick(this.targetBranch, commitsIDs);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Merging commits from <{}> to <{}>", (Object)this.sourceBranch, (Object)this.targetBranch);
        }
        return Arrays.asList(commitsIDs);
    }

    private List<String> doMerge(RevCommit commonAncestorCommit, RevCommit lastSourceCommit, RevCommit lastTargetCommit) {
        try {
            CommitContent commitContent = this.createCommitContent(commonAncestorCommit, lastSourceCommit, lastTargetCommit);
            boolean effective = this.git.commit(this.targetBranch, this.commitInfo, false, (ObjectId)lastTargetCommit, commitContent);
            if (effective) {
                return Collections.singletonList(this.git.getLastCommit(this.targetBranch).getName());
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GitException(String.format("Cannot merge branches from <%s> to <%s>", this.sourceBranch, this.targetBranch));
        }
        return Collections.emptyList();
    }

    private CommitContent createCommitContent(RevCommit commonAncestorCommit, RevCommit lastSourceCommit, RevCommit lastTargetCommit) {
        Map<String, File> contents = this.git.mapDiffContent(this.sourceBranch, commonAncestorCommit.getName(), lastSourceCommit.getName());
        if (this.squash) {
            return new DefaultCommitContent(contents);
        }
        List<RevCommit> parents = Arrays.asList(lastTargetCommit, lastSourceCommit);
        return new MergeCommitContent(contents, parents);
    }
}

