/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.RemoteRemoveCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.internal.storage.file.WindowCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FileUtils;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;

public class SubdirectoryClone {
    private final File repoDir;
    private final String origin;
    private final CredentialsProvider credentialsProvider;
    private final KetchLeaderCache leaders;
    private final File hookDir;
    private final boolean sslVerify;
    private Logger logger = LoggerFactory.getLogger(SubdirectoryClone.class);
    private List<String> branches;
    private String subdirectory;

    public SubdirectoryClone(File directory, String origin, String subdirectory, List<String> branches, CredentialsProvider credentialsProvider, KetchLeaderCache leaders, File hookDir) {
        this(directory, origin, subdirectory, branches, credentialsProvider, leaders, hookDir, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY);
    }

    public SubdirectoryClone(File directory, String origin, String subdirectory, List<String> branches, CredentialsProvider credentialsProvider, KetchLeaderCache leaders, File hookDir, boolean sslVerify) {
        this.subdirectory = SubdirectoryClone.ensureTrailingSlash(subdirectory);
        this.branches = branches;
        this.repoDir = (File)PortablePreconditions.checkNotNull((String)"directory", (Object)directory);
        this.origin = PortablePreconditions.checkNotEmpty((String)"origin", (String)origin);
        this.credentialsProvider = credentialsProvider;
        this.leaders = leaders;
        this.hookDir = hookDir;
        this.sslVerify = sslVerify;
    }

    private static String ensureTrailingSlash(String subdirectory) {
        if (subdirectory.endsWith("/")) {
            return subdirectory;
        }
        return subdirectory + "/";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Git execute() {
        Git git = new Clone(this.repoDir, this.origin, false, this.branches, this.credentialsProvider, this.leaders, this.hookDir, this.sslVerify).execute().get();
        Repository repository = git.getRepository();
        try (ObjectReader reader = repository.newObjectReader();){
            Git git2;
            block14: {
                ObjectInserter inserter = repository.newObjectInserter();
                try {
                    HashMap<ObjectId, ObjectId> commitMap = new HashMap<ObjectId, ObjectId>();
                    RevWalk revWalk = this.createRevWalk(repository, reader);
                    this.transformBranches(repository, reader, inserter, revWalk, commitMap);
                    this.overrideBranchNames(repository, revWalk, commitMap);
                    this.removeOriginRemote(repository);
                    git2 = git;
                    if (inserter == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inserter != null) {
                        try {
                            inserter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inserter.close();
            }
            return git2;
        }
        catch (Exception e) {
            String message = String.format("Error cloning origin <%s> with subdirectory <%s>.", this.origin, this.subdirectory);
            this.logger.error(message);
            this.cleanupDir(git.getRepository().getDirectory());
            throw new Clone.CloneException(message, e);
        }
    }

    private void removeOriginRemote(Repository repository) throws GitAPIException {
        org.eclipse.jgit.api.Git git = org.eclipse.jgit.api.Git.wrap((Repository)repository);
        RemoteRemoveCommand cmd = git.remoteRemove();
        cmd.setName(this.origin);
        cmd.call();
    }

    private void overrideBranchNames(Repository repository, RevWalk revWalk, Map<ObjectId, ObjectId> commitMap) throws AmbiguousObjectException, IncorrectObjectTypeException, java.io.IOException, MissingObjectException, GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException {
        for (String branchName : this.branches) {
            if (branchName.equals("HEAD")) continue;
            ObjectId oldBranchTipId = repository.resolve(branchName);
            ObjectId newBranchTipId = this.closestMappedAncestorOrSelf(commitMap, revWalk.parseCommit((AnyObjectId)oldBranchTipId))[0];
            RevCommit newBranchTip = revWalk.parseCommit((AnyObjectId)newBranchTipId);
            org.eclipse.jgit.api.Git.wrap((Repository)repository).branchCreate().setName(branchName).setForce(true).setStartPoint(newBranchTip).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK).call();
        }
    }

    private void transformBranches(Repository repository, ObjectReader reader, ObjectInserter inserter, RevWalk revWalk, Map<ObjectId, ObjectId> commitMap) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, java.io.IOException, UnmergedPathException {
        for (RevCommit commit : revWalk) {
            try {
                Optional<ObjectId> oNewCommitTree = this.filterCommitTree(reader, inserter, commit);
                if (!oNewCommitTree.isPresent()) continue;
                ObjectId newCommitTree = oNewCommitTree.get();
                CommitBuilder commitBuilder = this.generateNewCommit(commitMap, commit, newCommitTree);
                ObjectId newCommitId = inserter.insert(commitBuilder);
                if (!this.isOrphanCommit(commitBuilder) && !this.isMergeCommit(commitBuilder) && !this.isDifferentFromParent(revWalk, commitBuilder)) continue;
                commitMap.put(commit.getId(), newCommitId);
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("Problem occurred for commit [%s].", commit.getId().name()), t);
            }
        }
    }

    private boolean isOrphanCommit(CommitBuilder commitBuilder) {
        return commitBuilder.getParentIds().length == 0;
    }

    private boolean isDifferentFromParent(RevWalk revWalk, CommitBuilder commitBuilder) throws MissingObjectException, IncorrectObjectTypeException, java.io.IOException {
        ObjectId parentId = commitBuilder.getParentIds()[0];
        RevCommit parentCommit = revWalk.parseCommit((AnyObjectId)parentId);
        ObjectId parentTreeId = parentCommit.getTree().getId();
        ObjectId commitTreeId = commitBuilder.getTreeId();
        return !commitTreeId.equals((AnyObjectId)parentTreeId);
    }

    private boolean isMergeCommit(CommitBuilder commitBuilder) {
        return commitBuilder.getParentIds().length > 1;
    }

    private Optional<ObjectId> filterCommitTree(ObjectReader reader, ObjectInserter inserter, RevCommit commit) throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, java.io.IOException, UnmergedPathException {
        DirCache dc = DirCache.newInCore();
        DirCacheEditor editor = dc.editor();
        TreeWalk treeWalk = new TreeWalk(reader);
        int treeId = treeWalk.addTree((AnyObjectId)commit.getTree());
        treeWalk.setRecursive(true);
        boolean empty = true;
        while (treeWalk.next()) {
            String pathString = treeWalk.getPathString();
            CanonicalTreeParser treeParser = (CanonicalTreeParser)treeWalk.getTree(treeId, CanonicalTreeParser.class);
            if (!this.inSubdirectory(pathString)) continue;
            this.moveFromSubdirectoryToRoot(editor, pathString, treeParser);
            empty = false;
        }
        editor.finish();
        if (empty) {
            return Optional.empty();
        }
        return Optional.of(dc.writeTree(inserter));
    }

    private RevWalk createRevWalk(Repository repository, ObjectReader reader) throws MissingObjectException, IncorrectObjectTypeException, java.io.IOException {
        RevWalk revWalk = new RevWalk(reader);
        List<RevCommit> branchTips = this.getBranchCommits(repository, revWalk);
        revWalk.markStart(branchTips);
        revWalk.sort(RevSort.TOPO, true);
        revWalk.sort(RevSort.REVERSE, true);
        revWalk.setRevFilter(RevFilter.ALL);
        revWalk.setTreeFilter(TreeFilter.ALL);
        return revWalk;
    }

    private List<RevCommit> getBranchCommits(Repository repository, RevWalk revWalk) {
        List<RevCommit> branchTips = this.branches.stream().map(b -> {
            try {
                return revWalk.parseCommit((AnyObjectId)repository.resolve(b));
            }
            catch (java.io.IOException ioe) {
                throw new IllegalArgumentException(String.format("Unable to parse branch [%s] in repository [%s].", b, repository.getDirectory()));
            }
        }).collect(Collectors.toList());
        return branchTips;
    }

    private CommitBuilder generateNewCommit(Map<ObjectId, ObjectId> commitMap, RevCommit commit, ObjectId newCommitTree) {
        CommitBuilder commitBuilder = new CommitBuilder();
        commitBuilder.setAuthor(commit.getAuthorIdent());
        commitBuilder.setCommitter(commit.getCommitterIdent());
        commitBuilder.setTreeId((AnyObjectId)newCommitTree);
        commitBuilder.setMessage(commit.getFullMessage());
        commitBuilder.setEncoding(commit.getEncoding());
        ObjectId[] newParentIds = this.closestMappedAncestorOrSelf(commitMap, commit.getParents());
        if (newParentIds.length > 0) {
            commitBuilder.setParentIds(newParentIds);
        }
        return commitBuilder;
    }

    private ObjectId[] closestMappedAncestorOrSelf(Map<ObjectId, ObjectId> commitMap, RevCommit ... start) {
        LinkedList<RevCommit> commitQueue = new LinkedList<RevCommit>();
        HashSet<ObjectId> processed = new HashSet<ObjectId>();
        commitQueue.addAll(Arrays.asList(start));
        ArrayList<ObjectId> results = new ArrayList<ObjectId>();
        while (!commitQueue.isEmpty()) {
            RevCommit cur = (RevCommit)commitQueue.poll();
            if (processed.contains(cur.getId())) continue;
            ObjectId mappedId = commitMap.get(cur.getId());
            if (mappedId != null) {
                results.add(mappedId);
            } else {
                Arrays.stream(cur.getParents()).forEach(p -> commitQueue.add((RevCommit)p));
            }
            processed.add(cur.getId());
        }
        return results.toArray(new ObjectId[results.size()]);
    }

    private void moveFromSubdirectoryToRoot(DirCacheEditor editor, String pathString, CanonicalTreeParser treeParser) {
        String newPath = pathString.substring(this.subdirectory.length());
        final ObjectId entryObjectId = treeParser.getEntryObjectId();
        final FileMode entryFileMode = treeParser.getEntryFileMode();
        editor.add(new DirCacheEditor.PathEdit(new DirCacheEntry(newPath)){

            public void apply(DirCacheEntry ent) {
                ent.setObjectId((AnyObjectId)entryObjectId);
                ent.setFileMode(entryFileMode);
            }
        });
    }

    private boolean inSubdirectory(String pathString) {
        return pathString.startsWith(this.subdirectory);
    }

    private void cleanupDir(File gitDir) {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                WindowCache.reconfigure((WindowCacheConfig)new WindowCacheConfig());
            }
            FileUtils.delete((File)gitDir, (int)3);
        }
        catch (java.io.IOException e) {
            throw new IOException("Failed to remove the git repository.", (Exception)e);
        }
    }
}

