/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.base.attributes;

import java.util.HashMap;
import java.util.Map;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.AbstractBasicFileAttributeView;
import org.uberfire.java.nio.base.attributes.HiddenAttributes;
import org.uberfire.java.nio.file.Path;

public abstract class HiddenAttributeView<P extends Path>
extends AbstractBasicFileAttributeView<P> {
    public static final String HIDDEN = "hidden";

    public HiddenAttributeView(P path) {
        super(path);
    }

    @Override
    public String name() {
        return HIDDEN;
    }

    public abstract HiddenAttributes readAttributes() throws IOException;

    @Override
    public Map<String, Object> readAttributes(final String ... attributes) {
        final HiddenAttributes attrs = this.readAttributes();
        return new HashMap<String, Object>(super.readAttributes(attributes)){
            {
                super(x0);
                for (String attribute : attributes) {
                    PortablePreconditions.checkNotEmpty((String)"attribute", (String)attribute);
                    if (attribute.equals("*") || attribute.equals(HiddenAttributeView.HIDDEN)) {
                        this.put(HiddenAttributeView.HIDDEN, attrs.isHidden());
                    }
                    if (attribute.equals("*")) break;
                }
            }
        };
    }
}

