/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl;

import java.util.List;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.preferences.shared.PreferenceScope;
import org.uberfire.preferences.shared.PreferenceScopeResolver;
import org.uberfire.preferences.shared.impl.DefaultScopes;
import org.uberfire.preferences.shared.impl.exception.InvalidPreferenceScopeException;

@Portable
public class DefaultPreferenceScopeResolver
implements PreferenceScopeResolver {
    private final List<PreferenceScope> order;

    public DefaultPreferenceScopeResolver(@MapsTo(value="order") List<PreferenceScope> order) {
        this.order = order;
    }

    @Override
    public PreferenceScope resolve(String ... scopeTypes) {
        if (scopeTypes != null && scopeTypes.length >= 1 && scopeTypes.length <= 2) {
            if (scopeTypes.length == 2) {
                return this.getScopeFromOrder(scopeTypes);
            }
            String scopeType = scopeTypes[0];
            if (scopeType.equals(DefaultScopes.USER.type())) {
                return this.getScopeFromOrder(DefaultScopes.USER.type(), DefaultScopes.ENTIRE_APPLICATION.type());
            }
            if (scopeType.equals(DefaultScopes.ALL_USERS.type())) {
                return this.getScopeFromOrder(DefaultScopes.ALL_USERS.type(), DefaultScopes.ENTIRE_APPLICATION.type());
            }
            if (scopeType.equals(DefaultScopes.COMPONENT.type())) {
                return this.getScopeFromOrder(DefaultScopes.ALL_USERS.type(), DefaultScopes.COMPONENT.type());
            }
            if (scopeType.equals(DefaultScopes.ENTIRE_APPLICATION.type())) {
                return this.getScopeFromOrder(DefaultScopes.ALL_USERS.type(), DefaultScopes.ENTIRE_APPLICATION.type());
            }
        }
        throw new InvalidPreferenceScopeException("The passed scope types are invalid.");
    }

    private PreferenceScope getScopeFromOrder(String ... scopeTypes) {
        for (PreferenceScope scope : this.order) {
            boolean match = true;
            PreferenceScope currentScope = scope;
            for (int i = 0; i < scopeTypes.length; ++i) {
                if (currentScope == null || !currentScope.type().equals(scopeTypes[i])) {
                    match = false;
                    break;
                }
                currentScope = currentScope.childScope();
            }
            if (!match || currentScope != null) continue;
            return scope;
        }
        throw new InvalidPreferenceScopeException("The passed scope types are invalid.");
    }
}

