/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.preferences.shared.impl.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.uberfire.preferences.shared.PropertyValidator;
import org.uberfire.preferences.shared.impl.validation.ConstrainedValuesValidator;
import org.uberfire.preferences.shared.impl.validation.ValidationResult;

public class EnumValuePropertyValidator<T extends Enum<?>>
implements PropertyValidator {
    private final ConstrainedValuesValidator<String> validator = new ConstrainedValuesValidator<String>(() -> EnumValuePropertyValidator.toCollection((Enum[])values), EnumValuePropertyValidator::parseString);

    public EnumValuePropertyValidator(T[] values) {
    }

    public ValidationResult validate(Object value) {
        return this.validator.validate(value);
    }

    public static <T extends Enum<?>> String format(T value) {
        return value.name().toUpperCase();
    }

    public static String parseString(Object value) {
        return value.toString().toUpperCase();
    }

    private static <T extends Enum<?>> Collection<String> toCollection(T[] values) {
        return Arrays.stream(values).map(EnumValuePropertyValidator::format).collect(Collectors.toList());
    }
}

