/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.builder.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.shared.message.Level;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class BuildResults {
    private GAV gav;
    private ArrayList<BuildMessage> messages = new ArrayList();
    private Map<String, String> parameters = new HashMap<String, String>();
    private String rootPathURI;

    public BuildResults() {
    }

    public BuildResults(GAV gav) {
        this.gav = gav;
    }

    public GAV getGAV() {
        return this.gav;
    }

    public List<BuildMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public List<BuildMessage> getErrorMessages() {
        return Collections.unmodifiableList(this.filterMessages(Level.ERROR));
    }

    public List<BuildMessage> getWarningMessages() {
        return Collections.unmodifiableList(this.filterMessages(Level.WARNING));
    }

    public List<BuildMessage> getInformationMessages() {
        return Collections.unmodifiableList(this.filterMessages(Level.INFO));
    }

    private List<BuildMessage> filterMessages(Level level) {
        ArrayList<BuildMessage> filteredMessages = new ArrayList<BuildMessage>();
        for (BuildMessage msg : this.messages) {
            if (msg.getLevel() != level) continue;
            filteredMessages.add(msg);
        }
        return filteredMessages;
    }

    public void addBuildMessage(BuildMessage message) {
        this.messages.add(message);
    }

    public void addBuildMessage(int index, BuildMessage message) {
        this.messages.add(index, message);
    }

    public void addAllBuildMessages(List<BuildMessage> buildMessages) {
        this.messages.addAll(buildMessages);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String getRootPathURI() {
        return this.rootPathURI;
    }

    public void setRootPathURI(String rootPathURI) {
        this.rootPathURI = rootPathURI;
    }
}

