/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.context;

import java.util.Objects;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.api.annotations.LocalEvent;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
@LocalEvent
public class WorkspaceProjectContextChangeEvent {
    private final OrganizationalUnit ou;
    private final WorkspaceProject workspaceProject;
    private final Module module;
    private final Package pkg;

    public WorkspaceProjectContextChangeEvent() {
        this.ou = null;
        this.workspaceProject = null;
        this.module = null;
        this.pkg = null;
    }

    public WorkspaceProjectContextChangeEvent(OrganizationalUnit ou) {
        this.ou = ou;
        this.workspaceProject = null;
        this.module = null;
        this.pkg = null;
    }

    public WorkspaceProjectContextChangeEvent(WorkspaceProject workspaceProject) {
        this(workspaceProject, null);
    }

    public WorkspaceProjectContextChangeEvent(WorkspaceProject workspaceProject, Module module) {
        this(workspaceProject, module, null);
    }

    public WorkspaceProjectContextChangeEvent(WorkspaceProject workspaceProject, Module module, Package pkg) {
        this.ou = workspaceProject != null ? workspaceProject.getOrganizationalUnit() : null;
        this.workspaceProject = workspaceProject;
        this.module = module;
        this.pkg = pkg;
    }

    public OrganizationalUnit getOrganizationalUnit() {
        return this.ou;
    }

    public WorkspaceProject getWorkspaceProject() {
        return this.workspaceProject;
    }

    public Module getModule() {
        return this.module;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.ou == null ? 0 : this.ou.hashCode());
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        result = 31 * result + (this.workspaceProject == null ? 0 : this.workspaceProject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WorkspaceProjectContextChangeEvent other = (WorkspaceProjectContextChangeEvent)obj;
        return Objects.equals(this.module, other.module) && Objects.equals(this.ou, other.ou) && Objects.equals(this.pkg, other.pkg) && Objects.equals(this.workspaceProject, other.workspaceProject);
    }

    public String toString() {
        return "WorkspaceProjectContextChangeEvent [ou=" + this.ou + ", workspaceProject=" + this.workspaceProject + ", module=" + this.module + ", pkg=" + this.pkg + "]";
    }
}

