/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.api.ContextualManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.RoleManager;
import org.uberfire.ext.security.management.api.UserManagementService;
import org.uberfire.ext.security.management.api.UserManager;
import org.uberfire.ext.security.management.api.UserSystemManager;
import org.uberfire.ext.security.management.api.validation.EntityValidator;
import org.uberfire.ext.security.management.validation.GroupValidatorImpl;
import org.uberfire.ext.security.management.validation.RoleValidatorImpl;
import org.uberfire.ext.security.management.validation.UserValidatorImpl;

@ApplicationScoped
public class BackendUserSystemManager
implements UserSystemManager {
    public static final String ENV_USER_MANAGEMENT_PREFIX = "org.uberfire.ext.security.management";
    public static final String ENV_USER_MANAGEMENT_SERVICE = "org.uberfire.ext.security.management.api.userManagementServices";
    public static final String SECURITY_MANAGEMENT_DESCRIPTOR = "security-management.properties";
    private static final Logger LOG = LoggerFactory.getLogger(BackendUserSystemManager.class);
    @Inject
    BeanManager beanManager;
    @Inject
    Instance<UserManagementService> userManagementServices;
    private UserManager usersManagementService;
    private GroupManager groupsManagementService;
    private RoleManager roleManagementService;
    private boolean isActive;

    @PostConstruct
    public void initialize() {
        this.loadDescriptor();
        UserManagementService userManagementService = this.getService();
        boolean isUserManagerActive = false;
        boolean isGroupManagerActive = false;
        boolean isRoleManagerActive = false;
        if (null != userManagementService) {
            ContextualManager m2;
            this.usersManagementService = userManagementService.users();
            if (this.usersManagementService != null) {
                try {
                    m2 = (ContextualManager)this.usersManagementService;
                    m2.initialize((UserSystemManager)this);
                    isUserManagerActive = true;
                }
                catch (ClassCastException m2) {
                }
                catch (Exception e) {
                    LOG.error("UsersManagementService initialization failure", (Throwable)e);
                }
            } else {
                LOG.warn("No management services for users available.");
            }
            this.groupsManagementService = userManagementService.groups();
            if (this.groupsManagementService != null) {
                try {
                    m2 = (ContextualManager)this.groupsManagementService;
                    m2.initialize((UserSystemManager)this);
                    isGroupManagerActive = true;
                }
                catch (ClassCastException m3) {
                }
                catch (Exception e) {
                    LOG.error("GroupManagementService initialization failure", (Throwable)e);
                }
            } else {
                LOG.warn("No management services for groups available.");
            }
            this.roleManagementService = userManagementService.roles();
            if (this.roleManagementService != null) {
                try {
                    m2 = (ContextualManager)this.roleManagementService;
                    m2.initialize((UserSystemManager)this);
                    isRoleManagerActive = true;
                }
                catch (ClassCastException m4) {
                }
                catch (Exception e) {
                    LOG.error("RoleManagementService initialization failure", (Throwable)e);
                }
            }
            this.isActive = isUserManagerActive && isGroupManagerActive && isRoleManagerActive;
        } else {
            LOG.warn("No user management services available.");
        }
    }

    public UserManager users() {
        return this.usersManagementService;
    }

    public GroupManager groups() {
        return this.groupsManagementService;
    }

    public RoleManager roles() {
        return this.roleManagementService;
    }

    public EntityValidator<User> usersValidator() {
        return new UserValidatorImpl();
    }

    public EntityValidator<Group> groupsValidator() {
        return new GroupValidatorImpl();
    }

    public EntityValidator<Role> rolesValidator() {
        return new RoleValidatorImpl();
    }

    public boolean isActive() {
        return this.isActive;
    }

    @PreDestroy
    public void onDestroy() {
        ContextualManager m2;
        if (this.usersManagementService != null) {
            try {
                m2 = (ContextualManager)this.usersManagementService;
                m2.destroy();
            }
            catch (ClassCastException m2) {
            }
            catch (Exception e) {
                LOG.error("UserManagementService destroy failure", (Throwable)e);
            }
        }
        if (this.groupsManagementService != null) {
            try {
                m2 = (ContextualManager)this.groupsManagementService;
                m2.destroy();
            }
            catch (ClassCastException m3) {
            }
            catch (Exception e) {
                LOG.error("GroupManagementService destroy failure", (Throwable)e);
            }
        }
        if (this.roleManagementService != null) {
            try {
                m2 = (ContextualManager)this.roleManagementService;
                m2.destroy();
            }
            catch (ClassCastException m4) {
            }
            catch (Exception e) {
                LOG.error("RoleManagementService destroy failure", (Throwable)e);
            }
        }
    }

    private UserManagementService getService() {
        String serviceName = System.getProperty(ENV_USER_MANAGEMENT_SERVICE);
        if (this.isEmpty(serviceName)) {
            LOG.warn("No user management services implementation specified neither at runtime or in the properties descriptor for security management.");
            return null;
        }
        Set beans = this.beanManager.getBeans(serviceName);
        if (beans == null || beans.isEmpty()) {
            LOG.warn("No bean found for name '" + serviceName + "'. " + serviceName + " services will not work.");
            return null;
        }
        LOG.info("Using the user management service named '" + serviceName + "'");
        Bean bean = (Bean)beans.iterator().next();
        if (beans.size() > 1) {
            LOG.warn("More than a single bean found for bean named '" + serviceName + "'. Using the first one found in the classpath with fully classified classname '" + bean.getBeanClass() + "'.");
        }
        CreationalContext context = this.beanManager.createCreationalContext((Contextual)bean);
        return (UserManagementService)this.beanManager.getReference(bean, (Type)bean.getBeanClass(), context);
    }

    private void loadDescriptor() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(SECURITY_MANAGEMENT_DESCRIPTOR);
        if (null != is) {
            try {
                Enumeration<?> propNames;
                Properties descriptorProperties = new Properties();
                descriptorProperties.load(is);
                if (!descriptorProperties.isEmpty() && null != (propNames = descriptorProperties.propertyNames()) && propNames.hasMoreElements()) {
                    while (propNames.hasMoreElements()) {
                        String propId = (String)propNames.nextElement();
                        if (!propId.startsWith(ENV_USER_MANAGEMENT_PREFIX) || !this.isEmpty(System.getProperty(propId))) continue;
                        System.setProperty(propId, descriptorProperties.getProperty(propId));
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Error reading security management properties descriptor.", (Throwable)e);
            }
        }
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

