/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.service;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.management.BackendUserSystemManager;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.api.GroupManager;
import org.uberfire.ext.security.management.api.GroupManagerSettings;
import org.uberfire.ext.security.management.api.exception.NoImplementationAvailableException;
import org.uberfire.ext.security.management.api.exception.SecurityManagementException;
import org.uberfire.ext.security.management.api.service.GroupManagerService;
import org.uberfire.ext.security.management.util.SecurityManagementUtils;

@Service
@ApplicationScoped
public class GroupManagerServiceImpl
implements GroupManagerService {
    private static final Logger LOG = LoggerFactory.getLogger(GroupManagerServiceImpl.class);
    @Inject
    private BackendUserSystemManager userSystemManager;
    private GroupManager service;

    @PostConstruct
    public void init() {
        this.service = this.userSystemManager.groups();
    }

    private GroupManager getService() throws SecurityManagementException {
        if (this.service == null) {
            throw new NoImplementationAvailableException();
        }
        return this.service;
    }

    public AbstractEntityManager.SearchResponse<Group> search(AbstractEntityManager.SearchRequest request) throws SecurityManagementException {
        GroupManager serviceImpl = this.getService();
        if (request.getPage() == 0) {
            throw new IllegalArgumentException("First page must be 1.");
        }
        Set<String> registeredRoleNames = SecurityManagementUtils.getRegisteredRoleNames();
        if (request.getConstrainedIdentifiers() == null) {
            request.setConstrainedIdentifiers(registeredRoleNames);
        } else {
            request.getConstrainedIdentifiers().addAll(registeredRoleNames);
        }
        return serviceImpl.search(request);
    }

    public Group get(String identifier) throws SecurityManagementException {
        GroupManager serviceImpl = this.getService();
        return (Group)serviceImpl.get(identifier);
    }

    public List<Group> getAll() throws SecurityManagementException {
        GroupManager serviceImpl = this.getService();
        return serviceImpl.getAll().stream().filter(group -> !SecurityManagementUtils.getRegisteredRoleNames().contains(group.getName())).collect(Collectors.toList());
    }

    public Group create(Group group) throws SecurityManagementException {
        String name = group.getName();
        if (this.isConstrained(name)) {
            throw new IllegalArgumentException("Group with name '" + name + "' cannot be created, as it is a constrained value (it is a role or the admin group");
        }
        GroupManager serviceImpl = this.getService();
        return (Group)serviceImpl.create((Object)group);
    }

    public Group update(Group group) throws SecurityManagementException {
        String name = group.getName();
        if (this.isConstrained(name)) {
            throw new IllegalArgumentException("Group with name '" + name + "' cannot be updated, as it is a constrained value (it is a role or the admin group");
        }
        GroupManager serviceImpl = this.getService();
        return (Group)serviceImpl.update((Object)group);
    }

    public void delete(String ... identifiers) throws SecurityManagementException {
        for (String name : identifiers) {
            if (!this.isConstrained(name)) continue;
            throw new IllegalArgumentException("Group with name '" + name + "' cannot be deleted, as it is a constrained value (it is a role or the admin group");
        }
        GroupManager serviceImpl = this.getService();
        serviceImpl.delete(identifiers);
    }

    public GroupManagerSettings getSettings() {
        GroupManager serviceImpl = this.getService();
        GroupManagerSettings settings = (GroupManagerSettings)serviceImpl.getSettings();
        if (null != settings) {
            settings.setConstrainedGroups(SecurityManagementUtils.getRegisteredRoleNames());
        }
        return settings;
    }

    public void assignUsers(String name, Collection<String> users) throws SecurityManagementException {
        GroupManager serviceImpl = this.getService();
        serviceImpl.assignUsers(name, users);
    }

    protected boolean isConstrained(String name) {
        return SecurityManagementUtils.getRegisteredRoleNames().contains(name);
    }
}

