/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.ejb.SessionContext;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.uberfire.security.Role;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.server.RolesRegistry;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class WebSphereRoleProviderServices {
    private static WebSphereRoleProviderServices instance;

    @PostConstruct
    public void init() {
        try {
            instance = (WebSphereRoleProviderServices)InitialContext.doLookup("java:module/WebSphereRoleProviderServices");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Collection<Role> getRoles() {
        try {
            ArrayList<Role> roles = new ArrayList<Role>();
            SessionContext sctxLookup = (SessionContext)InitialContext.doLookup("java:comp/EJBContext");
            for (Role enforcementRole : RolesRegistry.get().getRegisteredRoles()) {
                if (!sctxLookup.isCallerInRole(enforcementRole.getName())) continue;
                roles.add((Role)new RoleImpl(enforcementRole.getName()));
            }
            return roles;
        }
        catch (NamingException e) {
            return Collections.emptyList();
        }
    }
}

