/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.changerequest;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;

public class ChangeRequestPredicates {
    private ChangeRequestPredicates() {
    }

    public static Predicate<ChangeRequest> matchAll() {
        return elem -> true;
    }

    public static Predicate<ChangeRequest> matchId(Long id) {
        return elem -> elem.getId() == id.longValue();
    }

    public static Predicate<ChangeRequest> matchSearchFilter(String searchFilter, Function<ChangeRequest, String> searchableElementFunction) {
        return elem -> ((String)searchableElementFunction.apply((ChangeRequest)elem)).contains(searchFilter.toLowerCase());
    }

    public static Predicate<ChangeRequest> matchStatus(ChangeRequestStatus status) {
        return elem -> elem.getStatus() == status;
    }

    public static Predicate<ChangeRequest> matchInStatusList(List<ChangeRequestStatus> statusList) {
        return elem -> statusList.contains((Object)elem.getStatus());
    }

    public static Predicate<ChangeRequest> matchInTargetBranchList(List<String> targetBranches) {
        return elem -> targetBranches.contains(elem.getTargetBranch());
    }

    public static Predicate<ChangeRequest> matchSourceBranch(String branch) {
        return elem -> elem.getSourceBranch().equals(branch);
    }

    public static Predicate<ChangeRequest> matchTargetBranch(String branch) {
        return elem -> elem.getTargetBranch().equals(branch);
    }

    public static Predicate<ChangeRequest> matchSearchFilterAndStatusList(String searchFilter, Function<ChangeRequest, String> searchableElementFunction, List<ChangeRequestStatus> statusList) {
        return ChangeRequestPredicates.matchSearchFilter(searchFilter, searchableElementFunction).and(ChangeRequestPredicates.matchInStatusList(statusList));
    }

    public static Predicate<ChangeRequest> matchSourceOrTargetBranch(String branchName) {
        return ChangeRequestPredicates.matchSourceBranch(branchName).or(ChangeRequestPredicates.matchTargetBranch(branchName));
    }

    public static Predicate<ChangeRequest> matchSourceAndTargetAndStatus(String sourceBranchName, String targetBranchName, ChangeRequestStatus status) {
        return ChangeRequestPredicates.matchSourceBranch(sourceBranchName).and(ChangeRequestPredicates.matchTargetBranch(targetBranchName).and(ChangeRequestPredicates.matchStatus(status)));
    }

    public static Predicate<ChangeRequest> matchTargetBranchListAndOtherPredicate(List<String> targetBranches, Predicate<ChangeRequest> predicate) {
        return ChangeRequestPredicates.matchInTargetBranchList(targetBranches).and(predicate);
    }
}

