/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.text.StringEscapeUtils;
import org.uberfire.security.Contributor;

public class InputEscapeUtils {
    private InputEscapeUtils() {
    }

    public static Collection<Contributor> escapeContributorsNames(Collection<Contributor> contributors) {
        ArrayList<Contributor> escapedContributors = new ArrayList<Contributor>();
        contributors.forEach(contributor -> {
            String escapedName = InputEscapeUtils.escapeHtmlInput(contributor.getUsername());
            escapedContributors.add(new Contributor(escapedName, contributor.getType()));
        });
        return escapedContributors;
    }

    public static String escapeHtmlInput(String input) {
        if (input != null) {
            String escapedInput = StringEscapeUtils.escapeHtml4((String)input);
            escapedInput = escapedInput.replace("'", "");
            return escapedInput;
        }
        return null;
    }
}

