/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.clean.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.util.StoredIdentifierCase;
import org.unitils.dbmaintainer.clean.DBCleaner;
import org.unitils.dbmaintainer.util.BaseDatabaseAccessor;
import org.unitils.util.PropertyUtils;

public class DefaultDBCleaner
extends BaseDatabaseAccessor
implements DBCleaner {
    public static final String PROPKEY_PRESERVE_DATA_SCHEMAS = "dbMaintainer.preserveDataOnly.schemas";
    public static final String PROPKEY_PRESERVE_DATA_TABLES = "dbMaintainer.preserveDataOnly.tables";
    public static final String PROPKEY_PRESERVE_TABLES = "dbMaintainer.preserve.tables";
    public static final String PROPKEY_VERSION_TABLE_NAME = "dbMaintainer.executedScriptsTableName";
    private static Log logger = LogFactory.getLog(DefaultDBCleaner.class);
    protected Set<String> schemasToPreserve;
    protected Set<String> tablesToPreserve;

    @Override
    protected void doInit(Properties configuration) {
        this.schemasToPreserve = this.getItemsToPreserve("dbMaintainer.preserve.schemas", false);
        this.schemasToPreserve.addAll(this.getItemsToPreserve(PROPKEY_PRESERVE_DATA_SCHEMAS, false));
        this.tablesToPreserve = this.getItemsToPreserve(PROPKEY_VERSION_TABLE_NAME, true);
        this.tablesToPreserve.addAll(this.getItemsToPreserve(PROPKEY_PRESERVE_TABLES, true));
        this.tablesToPreserve.addAll(this.getItemsToPreserve(PROPKEY_PRESERVE_DATA_TABLES, true));
    }

    @Override
    public void cleanSchemas() {
        for (DbSupport dbSupport : this.dbSupports) {
            if (this.isItemToPreserve(dbSupport.getSchemaName(), this.schemasToPreserve)) continue;
            logger.info((Object)("Cleaning database schema " + dbSupport.getSchemaName()));
            Set tableNames = dbSupport.getTableNames();
            for (String tableName : tableNames) {
                if (this.isItemToPreserve(tableName, this.tablesToPreserve) || this.isItemToPreserve(dbSupport.getSchemaName() + "." + tableName, this.tablesToPreserve)) continue;
                this.cleanTable(tableName, dbSupport);
            }
        }
    }

    protected void cleanTable(String tableName, DbSupport dbSupport) {
        logger.debug((Object)("Deleting all records from table " + tableName + " in database schema " + dbSupport.getSchemaName()));
        this.sqlHandler.executeUpdate("delete from " + dbSupport.qualified(tableName));
    }

    protected boolean isItemToPreserve(String item, Set<String> itemsToPreserve) {
        if (this.defaultDbSupport.getStoredIdentifierCase() == StoredIdentifierCase.MIXED_CASE) {
            item = item.toUpperCase();
        }
        return itemsToPreserve.contains(item);
    }

    protected Set<String> getItemsToPreserve(String propertyName, boolean prefixDefaultSchema) {
        HashSet<String> result = new HashSet<String>();
        List itemsToPreserve = PropertyUtils.getStringList((String)propertyName, (Properties)this.configuration);
        for (String itemToPreserve : itemsToPreserve) {
            if (this.defaultDbSupport.getStoredIdentifierCase() == StoredIdentifierCase.MIXED_CASE) {
                itemToPreserve = itemToPreserve.toUpperCase();
            }
            String correctCaseitemToPreserve = this.defaultDbSupport.toCorrectCaseIdentifier(itemToPreserve);
            if (prefixDefaultSchema && correctCaseitemToPreserve.indexOf(46) == -1) {
                correctCaseitemToPreserve = this.defaultDbSupport.getSchemaName() + "." + correctCaseitemToPreserve;
            }
            result.add(correctCaseitemToPreserve);
        }
        return result;
    }
}

