/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.IncludeTableFilter;
import org.unitils.core.UnitilsException;
import org.unitils.dbunit.dataset.Column;
import org.unitils.dbunit.dataset.Row;
import org.unitils.dbunit.dataset.Schema;
import org.unitils.dbunit.dataset.Table;

public class SchemaFactory {
    public Schema createSchemaForDbUnitDataSet(String schemaName, IDataSet dbUnitDataSet) {
        Schema result = new Schema(schemaName);
        try {
            this.addTables(dbUnitDataSet, result);
            return result;
        }
        catch (DataSetException e) {
            throw new UnitilsException("Unable to create data set for db unit data set. Schema name: " + schemaName, (Throwable)e);
        }
    }

    public Schema createSchemaForDbUnitDataSet(String schemaName, IDataSet dbUnitDataSet, List<String> tablesToInclude) {
        FilteredDataSet filteredDataSet = new FilteredDataSet((ITableFilter)new IncludeTableFilter(tablesToInclude.toArray(new String[tablesToInclude.size()])), dbUnitDataSet);
        return this.createSchemaForDbUnitDataSet(schemaName, (IDataSet)filteredDataSet);
    }

    protected void addTables(IDataSet dbUnitDataSet, Schema schema) throws DataSetException {
        ITableIterator dbUnitTableIterator = dbUnitDataSet.iterator();
        while (dbUnitTableIterator.next()) {
            ITable dbUnitTable = dbUnitTableIterator.getTable();
            String tableName = dbUnitTable.getTableMetaData().getTableName();
            List<String> primaryKeyColumnNames = this.getPrimaryKeyColumnNames(dbUnitTable);
            Table table = schema.getTable(tableName);
            if (table == null) {
                table = new Table(tableName);
                schema.addTable(table);
            }
            this.addRows(dbUnitTable, table, primaryKeyColumnNames);
        }
    }

    protected boolean shouldIgnoreTable(String tableName, List<String> tablesToInclude) {
        if (tablesToInclude == null) {
            return false;
        }
        for (String tableToInclude : tablesToInclude) {
            if (!tableToInclude.equalsIgnoreCase(tableName)) continue;
            return false;
        }
        return true;
    }

    protected void addRows(ITable dbUnitTable, Table table, List<String> primaryKeyColumnNames) throws DataSetException {
        org.dbunit.dataset.Column[] columns = dbUnitTable.getTableMetaData().getColumns();
        int rowCount = dbUnitTable.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Row row = new Row();
            table.addRow(row);
            for (org.dbunit.dataset.Column dbUnitColumn : columns) {
                String columnName = dbUnitColumn.getColumnName();
                DataType columnType = dbUnitColumn.getDataType();
                Object value = dbUnitTable.getValue(rowIndex, columnName);
                Column column = new Column(columnName, columnType, value);
                if (primaryKeyColumnNames.contains(columnName)) {
                    row.addPrimaryKeyColumn(column);
                    continue;
                }
                row.addColumn(column);
            }
        }
    }

    protected List<String> getPrimaryKeyColumnNames(ITable dbUnitTable) throws DataSetException {
        ArrayList<String> result = new ArrayList<String>();
        for (org.dbunit.dataset.Column column : dbUnitTable.getTableMetaData().getPrimaryKeys()) {
            result.add(column.getColumnName());
        }
        return result;
    }
}

