/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbunit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.core.util.ConfigUtils;
import org.unitils.dbmaintainer.locator.ClassPathDataLocator;
import org.unitils.dbmaintainer.locator.resourcepickingstrategie.ResourcePickingStrategie;
import org.unitils.dbunit.datasetfactory.DataSetResolver;
import org.unitils.dbunit.util.FileHandler;
import org.unitils.util.PropertyUtils;

public class DataSetFileNamesHandler {
    public String getDefaultDataSetFileNameClassLevel(Class<?> testClass, String extension) {
        String className = testClass.getName();
        StringBuilder builder = new StringBuilder();
        if (className.contains(".")) {
            className = className.replace(".", "/");
        }
        builder.append(className);
        builder.append(".");
        builder.append(extension);
        return builder.toString();
    }

    public String getDefaultDataSetFileNameMethodLevel(Class<?> testClass, Method method, String extension) {
        String className = testClass.getName();
        StringBuilder builder = new StringBuilder();
        if (className.contains(".")) {
            className = className.substring(className.lastIndexOf(".") + 1);
        }
        builder.append(className);
        builder.append("-");
        builder.append(method.getName());
        builder.append(".");
        builder.append(extension);
        return builder.toString();
    }

    public String getDefaultExpectedDataSetFileName(Method method, Class<?> testClass, String extension) {
        String className = testClass.getName();
        return className.replace(".", "/") + "." + method.getName() + "-result." + extension;
    }

    public String generateResourceName(String nameResource, Package packageTestClass) {
        String cloneResource = new String(nameResource);
        String packageName = packageTestClass != null ? packageTestClass.getName() : "";
        String tempName = "";
        if (cloneResource.startsWith(packageName.replace(".", "/"))) {
            cloneResource = tempName = cloneResource.substring(packageName.length());
        } else if (cloneResource.startsWith(packageName)) {
            cloneResource = tempName = cloneResource.substring(packageName.length() + 1);
        } else {
            tempName = cloneResource;
        }
        return cloneResource;
    }

    public String getDefaultDatasetBasedOnFilename(Class<?> testClass, Method method, String extension) {
        String name = this.getDefaultDataSetFileNameMethodLevel(testClass, method, extension);
        DataSetResolver dataSetResolver = this.getDataSetResolver();
        try {
            dataSetResolver.resolve(testClass, name);
            return testClass.getPackage().getName() + "." + name;
        }
        catch (Exception exception) {
            return this.getDefaultDataSetFileNameClassLevel(testClass, extension);
        }
    }

    public File locateResource(ClassPathDataLocator locator, String nameResource, ResourcePickingStrategie strategy, Class<?> testClass) {
        InputStream in = null;
        in = nameResource.startsWith("/") ? locator.getDataResource(nameResource.substring(1), strategy) : locator.getDataResource(nameResource, strategy);
        if (in == null) {
            File resolvedFile = this.getDataSetResolver().resolve(testClass, this.generateResourceName(nameResource, testClass.getPackage()));
            if (resolvedFile == null) {
                throw new UnitilsException("DataSetResource file with name '" + nameResource + "' cannot be found");
            }
            try {
                in = new FileInputStream(resolvedFile);
            }
            catch (FileNotFoundException e) {
                throw new UnitilsException("DataSetResource file with name '" + nameResource + "' cannot be found");
            }
        }
        FileHandler fileHandler = this.getFileHandler();
        File tempFile = fileHandler.createTempFile(nameResource);
        fileHandler.writeToFile(tempFile, in);
        return tempFile;
    }

    protected DataSetResolver getDataSetResolver() {
        return (DataSetResolver)ConfigUtils.getConfiguredInstanceOf(DataSetResolver.class, (Properties)this.getUnitilsConfiguration(), (String[])new String[0]);
    }

    protected Properties getUnitilsConfiguration() {
        return Unitils.getInstance().getConfiguration();
    }

    protected FileHandler getFileHandler() {
        return (FileHandler)PropertyUtils.getInstance((String)"org.unitils.dbunit.util.FileHandler.implClassName", (Object)new FileHandler(), (Properties)this.getUnitilsConfiguration());
    }
}

