/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.IOException;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;
import org.vafer.jdeb.utils.Utils;

public class DataProducerFiles
extends AbstractDataProducer {
    private final String[] files;
    private final String destDir;

    public DataProducerFiles(String[] files, String destDir, Mapper[] mappers) {
        super(null, null, mappers);
        this.files = files;
        this.destDir = destDir;
    }

    @Override
    public void produce(DataConsumer receiver) throws IOException {
        boolean hasDestDir = !Utils.isNullOrEmpty(this.destDir);
        for (String fileName : this.files) {
            File f = new File(fileName);
            if (hasDestDir) {
                fileName = Utils.movePath(fileName, this.destDir);
            }
            this.produceFile(receiver, f, fileName);
        }
    }
}

