/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.ReadContext;
import java.io.File;
import java.io.IOException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class IsJson<T>
extends TypeSafeMatcher<T> {
    private final Matcher<? super ReadContext> jsonMatcher;

    public IsJson(Matcher<? super ReadContext> matcher) {
        this.jsonMatcher = matcher;
    }

    protected boolean matchesSafely(T t) {
        try {
            ReadContext readContext = IsJson.parse(t);
            return this.jsonMatcher.matches((Object)readContext);
        }
        catch (JsonPathException jsonPathException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("is json ").appendDescriptionOf(this.jsonMatcher);
    }

    protected void describeMismatchSafely(T t, Description description) {
        try {
            ReadContext readContext = IsJson.parse(t);
            this.jsonMatcher.describeMismatch((Object)readContext, description);
        }
        catch (JsonPathException jsonPathException) {
            IsJson.buildMismatchDescription(t, description, (Exception)((Object)jsonPathException));
        }
        catch (IOException iOException) {
            IsJson.buildMismatchDescription(t, description, iOException);
        }
    }

    private static void buildMismatchDescription(Object object, Description description, Exception exception) {
        description.appendText("was ").appendValue(object).appendText(" which failed with ").appendValue((Object)exception.getMessage());
    }

    private static ReadContext parse(Object object) throws IOException {
        if (object instanceof String) {
            return JsonPath.parse((String)((String)object));
        }
        if (object instanceof File) {
            return JsonPath.parse((File)((File)object));
        }
        return JsonPath.parse((Object)object);
    }
}

