/*
 * Decompiled with CFR 0.152.
 */
package org.valid4j.matchers.jsonpath;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.ReadContext;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class WithJsonPath<T>
extends TypeSafeMatcher<ReadContext> {
    private final JsonPath jsonPath;
    private final Matcher<T> resultMatcher;

    public WithJsonPath(JsonPath jsonPath, Matcher<T> matcher) {
        this.jsonPath = jsonPath;
        this.resultMatcher = matcher;
    }

    protected boolean matchesSafely(ReadContext readContext) {
        try {
            Object object = readContext.read(this.jsonPath);
            return this.resultMatcher.matches(object);
        }
        catch (JsonPathException jsonPathException) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("with json path ").appendValue((Object)this.jsonPath.getPath()).appendText(" evaluated to ").appendDescriptionOf(this.resultMatcher);
    }

    protected void describeMismatchSafely(ReadContext readContext, Description description) {
        try {
            Object object = this.jsonPath.read(readContext.json());
            description.appendText("json path ").appendValue((Object)this.jsonPath.getPath()).appendText(" was evaluated to ").appendValue(object);
        }
        catch (PathNotFoundException pathNotFoundException) {
            description.appendText("json path ").appendValue((Object)this.jsonPath.getPath()).appendText(" was not found in ").appendValue(readContext.json());
        }
        catch (JsonPathException jsonPathException) {
            description.appendText("was ").appendValue(readContext.json());
        }
    }
}

