/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.walkmod.javalang.ASTParser;
import org.walkmod.javalang.ParseException;
import org.walkmod.javalang.ast.CompilationUnit;

public final class JavaParser {
    private static ASTParser parser;
    private static boolean cacheParser;

    private JavaParser() {
    }

    public static void setCacheParser(boolean value) {
        cacheParser = value;
        if (!value) {
            parser = null;
        }
    }

    public static CompilationUnit parse(InputStream in, String encoding) throws ParseException {
        if (cacheParser) {
            if (parser == null) {
                parser = new ASTParser(in, encoding);
            } else {
                parser.reset(in, encoding);
            }
            return parser.CompilationUnit();
        }
        return new ASTParser(in, encoding).CompilationUnit();
    }

    public static CompilationUnit parse(InputStream in) throws ParseException {
        return JavaParser.parse(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompilationUnit parse(File file, String encoding) throws ParseException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            CompilationUnit compilationUnit = JavaParser.parse(in, encoding);
            return compilationUnit;
        }
        finally {
            in.close();
        }
    }

    public static CompilationUnit parse(File file) throws ParseException, IOException {
        return JavaParser.parse(file, null);
    }

    static {
        cacheParser = true;
    }
}

