/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.actions;

import org.walkmod.javalang.actions.ActionType;

public abstract class Action {
    private int beginLine;
    private int beginColumn;
    private ActionType type;

    public Action(int beginLine, int beginPosition, ActionType type) {
        this.beginLine = beginLine;
        this.beginColumn = beginPosition;
        this.type = type;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public void setBeginColumn(int beginPosition) {
        this.beginColumn = beginPosition;
    }

    public ActionType getType() {
        return this.type;
    }

    public void setType(ActionType type) {
        this.type = type;
    }

    public abstract int getEndLine();

    public abstract int getEndColumn();

    public boolean isPreviousThan(int beginLine, int beginColumn) {
        if (beginLine > this.getEndLine()) {
            return true;
        }
        return beginLine == this.getEndLine() && beginColumn >= this.getEndColumn();
    }

    public boolean contains(Action action) {
        if (this.getBeginLine() < action.getBeginLine() || this.getBeginLine() == action.getBeginLine() && this.getBeginColumn() <= action.getBeginColumn()) {
            if (this.getEndLine() > action.getEndLine()) {
                return true;
            }
            if (this.getEndLine() == action.getEndLine() && this.getEndColumn() >= action.getEndColumn()) {
                return true;
            }
            if (this.getEndLine() > action.getBeginLine()) {
                return true;
            }
            if (this.getEndLine() == action.getBeginLine() && this.getEndColumn() > action.getBeginColumn()) {
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.getBeginLine() == this.getEndLine() && this.getBeginColumn() == this.getEndColumn();
    }
}

