/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast;

import java.io.File;
import java.net.URI;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Comment;
import org.walkmod.javalang.ast.ImportDeclaration;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.PackageDeclaration;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.comparators.CompilationUnitComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class CompilationUnit
extends Node
implements Mergeable<CompilationUnit> {
    private PackageDeclaration pakage;
    private List<ImportDeclaration> imports;
    private List<TypeDeclaration> types;
    private List<Comment> comments;
    private URI uri;
    private boolean withSymbols = false;

    public CompilationUnit() {
    }

    public CompilationUnit(PackageDeclaration pakage, List<ImportDeclaration> imports, List<TypeDeclaration> types, List<Comment> comments) {
        this.setPackage(pakage);
        this.setImports(imports);
        this.setTypes(types);
        this.setComments(comments);
    }

    public CompilationUnit(int beginLine, int beginColumn, int endLine, int endColumn, PackageDeclaration pakage, List<ImportDeclaration> imports, List<TypeDeclaration> types, List<Comment> comments) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setPackage(pakage);
        this.setImports(imports);
        this.setTypes(types);
        this.setComments(comments);
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> aux = new LinkedList<Node>();
        if (this.pakage != null) {
            aux.add(this.pakage);
        }
        if (this.imports != null) {
            aux.addAll(this.imports);
        }
        if (this.types != null) {
            aux.addAll(this.types);
        }
        if (this.comments != null) {
            aux.addAll(this.comments);
        }
        return aux;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (child instanceof ImportDeclaration) {
                if (this.imports != null) {
                    LinkedList<ImportDeclaration> auxImports = new LinkedList<ImportDeclaration>(this.imports);
                    result = auxImports.remove(child);
                    this.imports = auxImports;
                }
            } else if (child instanceof TypeDeclaration) {
                if (this.types != null) {
                    LinkedList<TypeDeclaration> typesAux = new LinkedList<TypeDeclaration>(this.types);
                    result = typesAux.remove(child);
                    this.types = typesAux;
                }
            } else if (child instanceof Comment) {
                if (this.comments != null) {
                    LinkedList<Comment> commentAux = new LinkedList<Comment>(this.comments);
                    result = commentAux.remove(child);
                    this.comments = commentAux;
                }
            } else if (child == this.pakage) {
                this.pakage = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(result);
        }
        return result;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public List<ImportDeclaration> getImports() {
        return this.imports;
    }

    public PackageDeclaration getPackage() {
        return this.pakage;
    }

    public List<TypeDeclaration> getTypes() {
        return this.types;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public void setImports(List<ImportDeclaration> imports) {
        this.imports = imports;
        this.setAsParentNodeOf(imports);
    }

    public void setPackage(PackageDeclaration pakage) {
        if (this.pakage != null) {
            this.updateReferences(this.pakage);
        }
        this.pakage = pakage;
        this.setAsParentNodeOf(pakage);
    }

    public void setTypes(List<TypeDeclaration> types) {
        this.types = types;
        this.setAsParentNodeOf(types);
    }

    public Comparator<?> getIdentityComparator() {
        return new CompilationUnitComparator();
    }

    public void merge(CompilationUnit remoteCU, MergeEngine configuration) {
        LinkedList<ImportDeclaration> resultImports = new LinkedList<ImportDeclaration>();
        configuration.apply(this.getImports(), remoteCU.getImports(), resultImports, ImportDeclaration.class);
        this.setImports(resultImports);
        LinkedList<TypeDeclaration> resultTypes = new LinkedList<TypeDeclaration>();
        configuration.apply(this.getTypes(), remoteCU.getTypes(), resultTypes, TypeDeclaration.class);
        this.setTypes(resultTypes);
        LinkedList<Comment> resultComments = new LinkedList<Comment>();
        configuration.apply(this.getComments(), remoteCU.getComments(), resultComments, Comment.class);
        this.setComments(resultComments);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<Comment> auxComments;
        LinkedList<TypeDeclaration> auxTypes;
        LinkedList<ImportDeclaration> auxImports;
        boolean updated = false;
        if (this.pakage == oldChild) {
            this.setPackage((PackageDeclaration)newChild);
            updated = true;
        }
        if (!updated && this.imports != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxImports = new LinkedList<ImportDeclaration>(this.imports)))) {
            this.imports = auxImports;
        }
        if (!updated && this.types != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxTypes = new LinkedList<TypeDeclaration>(this.types)))) {
            this.types = auxTypes;
        }
        if (!updated && this.comments != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxComments = new LinkedList<Comment>(this.comments)))) {
            this.comments = auxComments;
        }
        return updated;
    }

    public boolean hasEqualFileName(CompilationUnit other) {
        boolean samePackage = this.getPackage() == null && other.getPackage() == null;
        samePackage = samePackage || this.getPackage() != null && other.getPackage() != null && this.getPackage().equals(other.getPackage());
        boolean sameType = this.getTypes() == null && other.getTypes() == null;
        sameType = sameType || this.getTypes() != null && other.getTypes() != null && this.getTypes().get(0).getName().equals(other.getTypes().get(0).getName());
        return samePackage && sameType;
    }

    public String getQualifiedName() {
        String name = "";
        if (this.getPackage() != null) {
            name = this.getPackage().getName().toString();
        }
        if (this.getTypes() != null && !this.getTypes().isEmpty()) {
            if (this.getPackage() != null) {
                name = name + ".";
            }
            name = name + this.getTypes().get(0).getName();
        }
        return name;
    }

    public String getFileName() {
        String path = "";
        if (this.getPackage() != null) {
            NameExpr packageName = this.getPackage().getName();
            String packPath = packageName.toString().replace('.', File.separatorChar);
            path = path + packPath + File.separator + this.getSimpleName() + ".java";
        } else {
            path = path + this.getSimpleName() + ".java";
        }
        return path;
    }

    public String getSimpleName() {
        String name = "";
        if (this.getTypes() != null) {
            name = this.getTypes().get(0).getName();
        }
        return name;
    }

    @Override
    public CompilationUnit clone() throws CloneNotSupportedException {
        return new CompilationUnit(this.clone(this.pakage), this.clone(this.imports), this.clone(this.types), this.clone(this.comments));
    }

    public boolean withSymbols() {
        return this.withSymbols;
    }

    public void withSymbols(boolean isCompilable) {
        this.withSymbols = isCompilable;
    }
}

