/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Comment;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.visitors.DumpVisitor;
import org.walkmod.javalang.visitors.EqualsVisitor;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.modelchecker.ConstrainedElement;
import org.walkmod.modelchecker.Constraint;

public abstract class Node
implements Serializable,
Cloneable,
ConstrainedElement {
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;
    private Object data;
    private Node parentNode;
    private List<Constraint> constraints;
    private List<Constraint> constraintsAux;

    public Node() {
    }

    public void setConstraints(List<Constraint> constraints) {
        if (this.constraints != constraints) {
            List<Node> children;
            this.constraints = constraints;
            if (this.constraints != null && (children = this.getChildren()) != null) {
                for (Node child : children) {
                    child.setConstraints(constraints);
                }
            }
        }
    }

    public boolean remove() {
        Node parent = this.getParentNode();
        if (parent != null) {
            return parent.removeChild(this);
        }
        return false;
    }

    public abstract boolean removeChild(Node var1);

    public abstract List<Node> getChildren();

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public Node(int beginLine, int beginColumn, int endLine, int endColumn) {
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public abstract <R, A> R accept(GenericVisitor<R, A> var1, A var2);

    public abstract <A> void accept(VoidVisitor<A> var1, A var2);

    public final int getBeginColumn() {
        return this.beginColumn;
    }

    public final int getBeginLine() {
        return this.beginLine;
    }

    public final Object getData() {
        return this.data;
    }

    public final int getEndColumn() {
        return this.endColumn;
    }

    public final int getEndLine() {
        return this.endLine;
    }

    public final void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public final void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public final void setData(Object data) {
        this.data = data;
    }

    public final void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public final void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public void enableConstraints() {
        if (this.constraintsAux != null && this.constraints != null) {
            this.constraints.addAll(this.constraintsAux);
        }
    }

    public void diableConstraints() {
        if (this.constraints != null) {
            this.constraintsAux = new LinkedList<Constraint>(this.constraints);
            this.constraints.clear();
        }
    }

    public final String toString() {
        this.enableConstraints();
        DumpVisitor visitor = new DumpVisitor();
        this.accept(visitor, null);
        String aux = visitor.getSource();
        this.diableConstraints();
        return aux;
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return EqualsVisitor.equals(this, (Node)obj);
    }

    public boolean isNewNode() {
        return 0 == this.getEndLine() && 0 == this.getEndColumn() && this.getBeginLine() == 0;
    }

    public boolean contains(Node node2) {
        if (this.getBeginLine() < node2.getBeginLine() || this.getBeginLine() == node2.getBeginLine() && this.getBeginColumn() <= node2.getBeginColumn()) {
            if (this.getEndLine() > node2.getEndLine()) {
                return true;
            }
            if (this.getEndLine() == node2.getEndLine() && this.getEndColumn() >= node2.getEndColumn()) {
                return true;
            }
        }
        return false;
    }

    public boolean isInEqualLocation(Node node2) {
        if (!this.isNewNode() && !node2.isNewNode()) {
            return this.getBeginLine() == node2.getBeginLine() && this.getBeginColumn() == node2.getBeginColumn() && this.getEndLine() == node2.getEndLine() && this.getEndColumn() == node2.getEndColumn();
        }
        return false;
    }

    public boolean isPreviousThan(Node node) {
        if (this.getEndLine() < node.getBeginLine()) {
            return true;
        }
        return this.getEndLine() == node.getBeginLine() && this.getEndColumn() <= node.getBeginColumn();
    }

    public String getPrettySource(char indentationChar, int indentationLevel, int indentationSize) {
        return this.getPrettySource(indentationChar, indentationLevel, indentationSize, null);
    }

    public String getPrettySource(char indentationChar, int indentationLevel, int indentationSize, List<Comment> comments) {
        DumpVisitor visitor = new DumpVisitor();
        visitor.setIndentationChar(indentationChar);
        visitor.setIndentationLevel(indentationLevel);
        visitor.setIndentationSize(indentationSize);
        if (comments != null) {
            visitor.setComments(new LinkedList<Comment>(comments));
        }
        this.accept(visitor, null);
        return visitor.getSource();
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    private void setParentNode(Node parent) {
        this.parentNode = parent;
    }

    public boolean isAncestorOf(Node other) {
        for (Node parent = other.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (parent != this) continue;
            return true;
        }
        return false;
    }

    public Node getCommonAncestor(Node other) {
        for (Node parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            for (Node parent2 = other; parent2 != null; parent2 = parent2.getParentNode()) {
                if (parent != parent2) continue;
                return parent;
            }
        }
        return null;
    }

    protected void setAsParentNodeOf(List<? extends Node> childNodes) {
        if (childNodes != null) {
            for (Node node : childNodes) {
                node.setParentNode(this);
            }
        }
    }

    protected void setAsParentNodeOf(Node childNode) {
        if (childNode != null) {
            childNode.setParentNode(this);
        }
    }

    protected void updateReferences(Object o) {
        SymbolDefinition sd;
        List<SymbolReference> usages;
        List<SymbolReference> usages2;
        SymbolReference sr;
        SymbolDefinition sd2;
        if (o instanceof SymbolReference && (sd2 = (sr = (SymbolReference)o).getSymbolDefinition()) != null && (usages2 = sd2.getUsages()) != null) {
            Iterator<SymbolReference> it = usages2.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                SymbolReference current = it.next();
                if (current != o) continue;
                it.remove();
                found = true;
            }
        }
        if (o instanceof SymbolDefinition && (usages = (sd = (SymbolDefinition)o).getUsages()) != null) {
            Iterator<SymbolReference> it = usages.iterator();
            while (it.hasNext()) {
                SymbolReference current = it.next();
                current.setSymbolDefinition(null);
                it.remove();
            }
            List<SymbolReference> bodyRefs = sd.getBodyReferences();
            if (bodyRefs != null) {
                for (SymbolReference sr2 : bodyRefs) {
                    this.updateReferences(sr2);
                }
            }
        }
    }

    protected boolean replaceChildNodeInList(Node oldChild, Node newChild, List list) {
        if (list != null) {
            Iterator it = list.iterator();
            boolean updated = false;
            int i = 0;
            while (it.hasNext() && !updated) {
                Object current = it.next();
                if (current == oldChild) {
                    it.remove();
                    this.updateReferences(current);
                    updated = true;
                }
                if (updated) continue;
                ++i;
            }
            if (updated) {
                Node parent = oldChild.getParentNode();
                if (parent != null) {
                    parent.setAsParentNodeOf(newChild);
                }
                list.add(i, newChild);
            }
            return updated;
        }
        return false;
    }

    public abstract boolean replaceChildNode(Node var1, Node var2);

    protected <T extends Node> List<T> clone(List<T> original) throws CloneNotSupportedException {
        LinkedList<Node> aux = null;
        if (original != null) {
            aux = new LinkedList<Node>();
            for (Node node : original) {
                aux.add(this.clone(node));
            }
        }
        return aux;
    }

    protected <T extends Node> T clone(T node) throws CloneNotSupportedException {
        if (node == null) {
            return null;
        }
        return (T)((Node)node.clone());
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public boolean check() {
        if (this.constraints == null || this.constraints.isEmpty()) {
            return true;
        }
        Iterator<Constraint> it = this.constraints.iterator();
        boolean isConstrained = false;
        while (it.hasNext() && !isConstrained) {
            Constraint c = it.next();
            isConstrained = c.isConstrained((Object)this);
        }
        return !isConstrained;
    }
}

